/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.FileKeyStore;
import org.apache.qpid.server.security.FileTrustStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.jdbc.AbstractJDBCMessageStore;
import org.apache.qpid.server.store.jdbc.GenericJDBCMessageStore;
import org.apache.qpid.server.store.jdbc.JDBCContainer;
import org.apache.qpid.server.store.jdbc.JDBCDetails;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.virtualhost.AbstractVirtualHost;
import org.apache.qpid.server.virtualhost.jdbc.JDBCVirtualHost;

@ManagedObject(category=false, type="JDBC")
public class JDBCVirtualHostImpl
extends AbstractVirtualHost<JDBCVirtualHostImpl>
implements JDBCVirtualHost<JDBCVirtualHostImpl>,
JDBCContainer {
    public static final String VIRTUAL_HOST_TYPE = "JDBC";
    @ManagedAttributeField
    private String _connectionUrl;
    @ManagedAttributeField
    private String _connectionPoolType;
    @ManagedAttributeField
    private String _username;
    @ManagedAttributeField
    private String _password;
    @ManagedAttributeField
    private String _tableNamePrefix;
    @ManagedAttributeField
    private FileKeyStore<?> _keyStore;
    @ManagedAttributeField
    private String _keyStorePathPropertyName;
    @ManagedAttributeField
    private String _keyStorePasswordPropertyName;
    @ManagedAttributeField
    private FileTrustStore<?> _trustStore;
    @ManagedAttributeField
    private String _trustStorePathPropertyName;
    @ManagedAttributeField
    private String _trustStorePasswordPropertyName;

    @ManagedObjectFactoryConstructor
    public JDBCVirtualHostImpl(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(attributes, virtualHostNode);
    }

    protected MessageStore createMessageStore() {
        return new GenericJDBCMessageStore();
    }

    @Override
    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    @Override
    public String getConnectionPoolType() {
        return this._connectionPoolType;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public String getTableNamePrefix() {
        return this._tableNamePrefix;
    }

    @Override
    public FileKeyStore<?> getKeyStore() {
        return this._keyStore;
    }

    @Override
    public String getKeyStorePathPropertyName() {
        return this._keyStorePathPropertyName;
    }

    @Override
    public String getKeyStorePasswordPropertyName() {
        return this._keyStorePasswordPropertyName;
    }

    @Override
    public FileTrustStore<?> getTrustStore() {
        return this._trustStore;
    }

    @Override
    public String getTrustStorePathPropertyName() {
        return this._trustStorePathPropertyName;
    }

    @Override
    public String getTrustStorePasswordPropertyName() {
        return this._trustStorePasswordPropertyName;
    }

    @Override
    public JDBCDetails getJDBCDetails() {
        return JDBCDetails.getDetailsForJdbcUrl(this.getConnectionUrl(), this);
    }

    @Override
    public Connection getConnection() {
        try {
            return this.getStore().getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionScopedRuntimeException(String.format("Error opening connection to database for VirtualHost '%s'", this.getName()));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", connectionUrl=" + this.getConnectionUrl() + ", connectionPoolType=" + this.getConnectionPoolType() + ", username=" + this.getUsername() + "]";
    }

    @Override
    public void addDeleteAction(Action<Connection> action) {
        this.getStore().addDeleteAction(action);
    }

    @Override
    public void removeDeleteAction(Action<Connection> action) {
        this.getStore().removeDeleteAction(action);
    }

    private AbstractJDBCMessageStore getStore() {
        return (AbstractJDBCMessageStore)this.getMessageStore();
    }
}

