/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.security.Principal;
import java.util.Map;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.model.AbstractSystemConfig;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.SystemConfigFactoryConstructor;
import org.apache.qpid.server.security.FileKeyStore;
import org.apache.qpid.server.security.FileTrustStore;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.jdbc.GenericJDBCConfigurationStore;
import org.apache.qpid.server.store.jdbc.JDBCSystemConfig;
import org.apache.qpid.server.store.preferences.PreferenceStore;

@ManagedObject(category=false, type="JDBC")
public class JDBCSystemConfigImpl
extends AbstractSystemConfig<JDBCSystemConfigImpl>
implements JDBCSystemConfig<JDBCSystemConfigImpl> {
    public static final String SYSTEM_CONFIG_TYPE = "JDBC";
    @ManagedAttributeField
    private String _connectionUrl;
    @ManagedAttributeField
    private String _connectionPoolType;
    @ManagedAttributeField
    private String _username;
    @ManagedAttributeField
    private String _password;
    @ManagedAttributeField
    private String _tableNamePrefix;
    @ManagedAttributeField
    private FileKeyStore<?> _keyStore;
    @ManagedAttributeField
    private String _keyStorePathPropertyName;
    @ManagedAttributeField
    private String _keyStorePasswordPropertyName;
    @ManagedAttributeField
    private FileTrustStore<?> _trustStore;
    @ManagedAttributeField
    private String _trustStorePathPropertyName;
    @ManagedAttributeField
    private String _trustStorePasswordPropertyName;

    @SystemConfigFactoryConstructor
    public JDBCSystemConfigImpl(TaskExecutor taskExecutor, EventLogger eventLogger, Principal systemPrincipal, Map<String, Object> attributes) {
        super(taskExecutor, eventLogger, systemPrincipal, attributes);
    }

    protected DurableConfigurationStore createStoreObject() {
        return new GenericJDBCConfigurationStore(Broker.class);
    }

    @Override
    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    @Override
    public String getConnectionPoolType() {
        return this._connectionPoolType;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public String getTableNamePrefix() {
        return this._tableNamePrefix;
    }

    @Override
    public FileKeyStore<?> getKeyStore() {
        return this._keyStore;
    }

    @Override
    public String getKeyStorePathPropertyName() {
        return this._keyStorePathPropertyName;
    }

    @Override
    public String getKeyStorePasswordPropertyName() {
        return this._keyStorePasswordPropertyName;
    }

    @Override
    public FileTrustStore<?> getTrustStore() {
        return this._trustStore;
    }

    @Override
    public String getTrustStorePathPropertyName() {
        return this._trustStorePathPropertyName;
    }

    @Override
    public String getTrustStorePasswordPropertyName() {
        return this._trustStorePasswordPropertyName;
    }

    public PreferenceStore getPreferenceStore() {
        return ((GenericJDBCConfigurationStore)this.getConfigurationStore()).getPreferenceStore();
    }
}

