/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.List;

public class JVMSystemUtils {
    public static final boolean ZING_JVM = "Azul Systems, Inc.".equals(System.getProperty("java.vendor"));
    public static final int MIN_HEAP_MB = ZING_JVM ? 1024 : 0;
    private static final String ZING_MANAGEMENT_FACTORY_CLASS = "com.azul.zing.management.ManagementFactory";
    private static final String ZING_ACCESS_ERROR = "Could not access Zing management bean. Make sure -XX:+UseZingMXBeans was specified.";
    private static OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    private static final String MATCH_FILE_SEPARATOR = "\\" + File.separatorChar;

    public static double getSystemLoad() {
        return osBean.getSystemLoadAverage();
    }

    public static long getRuntimeMaxMemory() {
        String jvmVersion;
        if ("Mac OS X".equals(System.getProperty("os.name")) && (jvmVersion = System.getProperty("java.version")) != null && jvmVersion.startsWith("1.4.2")) {
            return Long.MAX_VALUE;
        }
        if (ZING_JVM) {
            try {
                Class<?> factoryClass = Class.forName(ZING_MANAGEMENT_FACTORY_CLASS);
                Method getBeanMethod = factoryClass.getMethod("getMemoryMXBean", new Class[0]);
                Object memoryBean = getBeanMethod.invoke(null, new Object[0]);
                Class<?> beanClass = memoryBean.getClass();
                Method getMaxMemoryMethod = beanClass.getMethod("getApplicationObjectHeapUsableMemory", new Class[0]);
                return (Long)getMaxMemoryMethod.invoke(memoryBean, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(ZING_ACCESS_ERROR, e);
            }
        }
        return Runtime.getRuntime().maxMemory();
    }

    public static long getSystemZingMemorySize() {
        try {
            if (!ZING_JVM) {
                throw new IllegalStateException("Only allowed under Zing");
            }
            Class<?> factoryClass = Class.forName(ZING_MANAGEMENT_FACTORY_CLASS);
            Method getPoolsMethod = factoryClass.getMethod("getMemoryPoolMXBeans", new Class[0]);
            List pools = (List)getPoolsMethod.invoke(null, new Object[0]);
            Class<?> poolClass = pools.get(0).getClass();
            Method getNameMethod = poolClass.getMethod("getName", new Class[0]);
            Method getSizeMethod = poolClass.getMethod("getCurrentSize", new Class[0]);
            for (Object pool : pools) {
                if (!"System Zing Memory".equals(getNameMethod.invoke(pool, new Object[0]))) continue;
                return (Long)getSizeMethod.invoke(pool, new Object[0]);
            }
            throw new IllegalStateException("System Zing Memory pool not found");
        }
        catch (Exception e) {
            throw new IllegalStateException(ZING_ACCESS_ERROR, e);
        }
    }

    public static void addZingJVMArgs(List<String> command) {
        JVMSystemUtils.insertZingJVMArgs(command, command.size());
    }

    public static void insertZingJVMArgs(List<String> command) {
        if (!ZING_JVM) {
            return;
        }
        String[] prog = command.get(0).split(MATCH_FILE_SEPARATOR);
        if (prog[prog.length - 1].equals("java")) {
            JVMSystemUtils.insertZingJVMArgs(command, 1);
        }
    }

    private static void insertZingJVMArgs(List<String> command, int insertAt) {
        if (!ZING_JVM) {
            return;
        }
        command.add(insertAt, "-XX:+UseZingMXBeans");
    }
}

