/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.networkRestore;

import com.sleepycat.je.rep.impl.networkRestore.NetworkBackupStatDefinition;
import com.sleepycat.je.utilint.LongAvgRateStat;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Serializable;

public class NetworkBackupStats
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final StatGroup statGroup;

    NetworkBackupStats(StatGroup statGroup) {
        this.statGroup = statGroup;
    }

    public int getBackupFileCount() {
        return this.statGroup.getInt(NetworkBackupStatDefinition.BACKUP_FILE_COUNT);
    }

    public int getSkipCount() {
        return this.statGroup.getInt(NetworkBackupStatDefinition.SKIP_COUNT);
    }

    public int getFetchCount() {
        return this.statGroup.getInt(NetworkBackupStatDefinition.FETCH_COUNT);
    }

    public int getDisposedCount() {
        return this.statGroup.getInt(NetworkBackupStatDefinition.DISPOSED_COUNT);
    }

    public long getExpectedBytes() {
        return this.statGroup.getLong(NetworkBackupStatDefinition.EXPECTED_BYTES);
    }

    public long getTransferredBytes() {
        return this.statGroup.getLong(NetworkBackupStatDefinition.TRANSFERRED_BYTES);
    }

    public long getTransferRate() {
        LongAvgRateStat stat = (LongAvgRateStat)this.statGroup.getStat(NetworkBackupStatDefinition.TRANSFER_RATE);
        return stat == null ? 0L : stat.get();
    }

    public String toString() {
        return this.statGroup.toString();
    }
}

