/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.logging.logback.EffectiveLevelFilter;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public final class QpidLoggerTurboFilter
extends TurboFilter {
    private final CopyOnWriteArrayList<EffectiveLevelFilter> _filters = new CopyOnWriteArrayList();
    private final AtomicReference<ConcurrentMap<Logger, Integer>> _effectiveLevels = new AtomicReference();
    private volatile int _minimumFilterLevel;
    private final Object _minimumFilterLevelUpdateLock;

    public QpidLoggerTurboFilter() {
        this._minimumFilterLevel = Level.OFF.levelInt;
        this._minimumFilterLevelUpdateLock = new Object();
        this.resetCacheAndSetMinimumLevel();
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (level.levelInt < this._minimumFilterLevel) {
            return FilterReply.DENY;
        }
        ConcurrentMap<Logger, Integer> effectiveLevels = this._effectiveLevels.get();
        Integer effectiveLoggerLevel = (Integer)effectiveLevels.get(logger);
        if (effectiveLoggerLevel == null) {
            effectiveLoggerLevel = Level.OFF.levelInt;
            for (EffectiveLevelFilter filter : this._filters) {
                Integer loggerLevel = filter.getEffectiveLevel((Logger)logger).levelInt;
                if (effectiveLoggerLevel < loggerLevel) continue;
                effectiveLoggerLevel = loggerLevel;
            }
            effectiveLevels.putIfAbsent(logger, effectiveLoggerLevel);
        }
        return level.levelInt >= effectiveLoggerLevel ? FilterReply.ACCEPT : FilterReply.DENY;
    }

    public void filterAdded(EffectiveLevelFilter filter) {
        if (this._filters.addIfAbsent(filter)) {
            this.resetCacheAndSetMinimumLevel();
        }
    }

    public void filterRemoved(EffectiveLevelFilter filter) {
        if (this._filters.remove(filter)) {
            this.resetCacheAndSetMinimumLevel();
        }
    }

    public void filterChanged(EffectiveLevelFilter filter) {
        if (this._filters.contains(filter)) {
            this.resetCacheAndSetMinimumLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCacheAndSetMinimumLevel() {
        this._minimumFilterLevel = Level.TRACE.levelInt;
        this._effectiveLevels.set(new ConcurrentHashMap());
        Object object = this._minimumFilterLevelUpdateLock;
        synchronized (object) {
            int newMinimumLogLevel = Level.OFF.levelInt;
            for (EffectiveLevelFilter filter : this._filters) {
                newMinimumLogLevel = Math.min(filter.getLevel().levelInt, newMinimumLogLevel);
            }
            this._minimumFilterLevel = newMinimumLogLevel;
        }
    }

    public boolean equals(Object o) {
        return o != null && ((Object)((Object)this)).getClass() == o.getClass();
    }

    public int hashCode() {
        return 0;
    }

    public static QpidLoggerTurboFilter installIfNecessary(LoggerContext loggerContext) {
        QpidLoggerTurboFilter filter = new QpidLoggerTurboFilter();
        if (!loggerContext.getTurboFilterList().addIfAbsent((Object)filter)) {
            for (TurboFilter candidate : loggerContext.getTurboFilterList()) {
                if (!(candidate instanceof QpidLoggerTurboFilter)) continue;
                filter = (QpidLoggerTurboFilter)candidate;
                break;
            }
        }
        return filter;
    }

    public static QpidLoggerTurboFilter installIfNecessaryToRootContext() {
        return QpidLoggerTurboFilter.installIfNecessary(QpidLoggerTurboFilter.getRootContext());
    }

    public static void uninstallFromRootContext() {
        QpidLoggerTurboFilter.uninstall(QpidLoggerTurboFilter.getRootContext());
    }

    public static void uninstall(LoggerContext context) {
        context.getTurboFilterList().remove((Object)new QpidLoggerTurboFilter());
    }

    private static LoggerContext getRootContext() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        return rootLogger.getLoggerContext();
    }

    public static void filterAdded(EffectiveLevelFilter filter, LoggerContext context) {
        QpidLoggerTurboFilter turboFilter = QpidLoggerTurboFilter.installIfNecessary(context);
        turboFilter.filterAdded(filter);
    }

    public static void filterRemoved(EffectiveLevelFilter filter, LoggerContext context) {
        QpidLoggerTurboFilter turboFilter = QpidLoggerTurboFilter.installIfNecessary(context);
        turboFilter.filterRemoved(filter);
    }

    private static void filterChanged(EffectiveLevelFilter filter, LoggerContext context) {
        QpidLoggerTurboFilter turboFilter = QpidLoggerTurboFilter.installIfNecessary(context);
        turboFilter.filterChanged(filter);
    }

    public static void filterAddedToRootContext(EffectiveLevelFilter filter) {
        QpidLoggerTurboFilter.filterAdded(filter, QpidLoggerTurboFilter.getRootContext());
    }

    public static void filterRemovedFromRootContext(EffectiveLevelFilter filter) {
        QpidLoggerTurboFilter.filterRemoved(filter, QpidLoggerTurboFilter.getRootContext());
    }

    public static void filterChangedOnRootContext(EffectiveLevelFilter filter) {
        QpidLoggerTurboFilter.filterChanged(filter, QpidLoggerTurboFilter.getRootContext());
    }
}

