/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.transport.NonBlockingConnection;
import org.apache.qpid.server.transport.NonBlockingNetworkTransport;
import org.apache.qpid.server.transport.SelectorThread;
import org.apache.qpid.server.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConnectionScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkConnectionScheduler.class);
    private final ThreadFactory _factory;
    private final String _selectorThreadName;
    private volatile ThreadPoolExecutor _executor;
    private final AtomicInteger _running = new AtomicInteger();
    private final int _poolSize;
    private final long _threadKeepAliveTimeout;
    private final String _name;
    private final int _numberOfSelectors;
    private SelectorThread _selectorThread;

    public NetworkConnectionScheduler(final String name, int numberOfSelectors, int threadPoolSize, long threadKeepAliveTimeout) {
        this(name, numberOfSelectors, threadPoolSize, threadKeepAliveTimeout, new ThreadFactory(){
            final AtomicInteger _count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("IO-pool-" + name + "-" + this._count.incrementAndGet());
                return t;
            }
        });
    }

    public String toString() {
        return "NetworkConnectionScheduler{_factory=" + String.valueOf(this._factory) + ", _executor=" + String.valueOf(this._executor) + ", _running=" + String.valueOf(this._running) + ", _poolSize=" + this._poolSize + ", _threadKeepAliveTimeout=" + this._threadKeepAliveTimeout + ", _name='" + this._name + "', _numberOfSelectors=" + this._numberOfSelectors + ", _selectorThread=" + String.valueOf(this._selectorThread) + "}";
    }

    public NetworkConnectionScheduler(String name, int numberOfSelectors, int threadPoolSize, long threadKeepAliveTimeout, ThreadFactory factory) {
        this._name = name;
        this._poolSize = threadPoolSize;
        this._threadKeepAliveTimeout = threadKeepAliveTimeout;
        this._factory = factory;
        this._numberOfSelectors = numberOfSelectors;
        this._selectorThreadName = "Selector-" + name;
    }

    public void start() {
        try {
            this._selectorThread = new SelectorThread(this, this._numberOfSelectors);
            int corePoolSize = this._poolSize;
            int maximumPoolSize = this._poolSize;
            long keepAliveTime = this._threadKeepAliveTimeout;
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            ThreadFactory factory = this._factory;
            this._executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MINUTES, workQueue, QpidByteBuffer.createQpidByteBufferTrackingThreadFactory(factory));
            this._executor.prestartAllCoreThreads();
            this._executor.allowCoreThreadTimeOut(true);
            for (int i = 0; i < this._poolSize; ++i) {
                this._executor.execute(this._selectorThread);
            }
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    void processConnection(NonBlockingConnection connection) {
        boolean rerun;
        Thread.currentThread().setName(connection.getThreadName());
        connection.doPreWork();
        do {
            rerun = false;
            boolean closed = connection.doWork();
            if (!closed && connection.getScheduler() == this) {
                if (connection.isStateChanged() || connection.isPartialRead()) {
                    if (this._running.get() == this._poolSize) {
                        connection.clearScheduled();
                        this.schedule(connection);
                        continue;
                    }
                    rerun = true;
                    continue;
                }
                connection.clearScheduled();
                if (connection.isStateChanged()) {
                    this._selectorThread.addToWork(connection);
                    continue;
                }
                this._selectorThread.returnConnectionToSelector(connection);
                continue;
            }
            if (connection.getScheduler() == this) continue;
            this.removeConnection(connection);
            connection.clearScheduled();
            connection.getScheduler().addConnection(connection);
        } while (rerun);
    }

    void decrementRunningCount() {
        this._running.decrementAndGet();
    }

    void incrementRunningCount() {
        this._running.incrementAndGet();
    }

    public void close() {
        if (this._selectorThread != null) {
            this._selectorThread.close();
        }
        if (this._executor != null) {
            this._executor.shutdown();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getSelectorThreadName() {
        return this._selectorThreadName;
    }

    public void addAcceptingSocket(ServerSocketChannel serverSocket, NonBlockingNetworkTransport nonBlockingNetworkTransport) {
        this._selectorThread.addAcceptingSocket(serverSocket, nonBlockingNetworkTransport);
    }

    public void cancelAcceptingSocket(ServerSocketChannel serverSocket) {
        this._selectorThread.cancelAcceptingSocket(serverSocket);
    }

    public void addConnection(NonBlockingConnection connection) {
        this._selectorThread.addConnection(connection);
    }

    public void removeConnection(NonBlockingConnection connection) {
        this._selectorThread.removeConnection(connection);
    }

    int getPoolSize() {
        return this._poolSize;
    }

    public void schedule(NonBlockingConnection connection) {
        this._selectorThread.addToWork(connection);
    }
}

