/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.serializer.v1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.store.serializer.v1.Record;
import org.apache.qpid.server.store.serializer.v1.RecordType;
import org.apache.qpid.server.store.serializer.v1.Serializer;

class Deserializer {
    private final MessageDigest _digest;
    private final InputStream _inputStream;

    Deserializer(InputStream inputStream) {
        this._inputStream = inputStream;
        try {
            this._digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("The required message digest algorithm SHA-256 is not supported in this JVM");
        }
    }

    Record readRecord() throws IOException {
        int recordOrdinal = this._inputStream.read();
        RecordType recordType = RecordType.values()[recordOrdinal];
        this._digest.update((byte)recordOrdinal);
        return recordType.read(this);
    }

    byte[] readBytes(int size) throws IOException {
        int read;
        byte[] bytes = new byte[size];
        for (int pos = 0; pos < size; pos += read) {
            read = this._inputStream.read(bytes, pos, size - pos);
            if (read != -1) continue;
            throw new EOFException("Unexpected end of input");
        }
        this._digest.update(bytes);
        return bytes;
    }

    long readLong() throws IOException {
        byte[] data = this.readBytes(8);
        try (QpidByteBuffer buf = QpidByteBuffer.wrap(data);){
            long l = buf.getLong();
            return l;
        }
    }

    int readInt() throws IOException {
        byte[] data = this.readBytes(4);
        try (QpidByteBuffer buf = QpidByteBuffer.wrap(data);){
            int n = buf.getInt();
            return n;
        }
    }

    UUID readUUID() throws IOException {
        byte[] data = this.readBytes(16);
        try (QpidByteBuffer buf = QpidByteBuffer.wrap(data);){
            long msb = buf.getLong();
            long lsb = buf.getLong();
            UUID uUID = new UUID(msb, lsb);
            return uUID;
        }
    }

    Record validateDigest() throws IOException {
        byte[] fileDigest;
        byte[] calculatedDigest = this._digest.digest();
        if (!Arrays.equals(calculatedDigest, fileDigest = this.readBytes(calculatedDigest.length))) {
            throw new IllegalArgumentException("Calculated checksum does not agree with that in the input");
        }
        if (this._inputStream.read() != -1) {
            throw new IllegalArgumentException("The import contains extra data after the digest");
        }
        return new Record(){

            @Override
            public RecordType getType() {
                return RecordType.DIGEST;
            }

            @Override
            public void writeData(Serializer output) throws IOException {
                output.write(fileDigest);
            }
        };
    }
}

