/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Collection;
import java.util.Date;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.model.Transport;

@ManagedObject(creatable=false, amqpName="org.apache.qpid.Connection")
public interface Connection<X extends Connection<X>>
extends ConfiguredObject<X> {
    public static final String STATE = "state";
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_VERSION = "clientVersion";
    public static final String INCOMING = "incoming";
    public static final String LOCAL_ADDRESS = "localAddress";
    public static final String PRINCIPAL = "principal";
    public static final String PROPERTIES = "properties";
    public static final String REMOTE_ADDRESS = "remoteAddress";
    public static final String REMOTE_PROCESS_NAME = "remoteProcessName";
    public static final String REMOTE_PROCESS_PID = "remoteProcessPid";
    public static final String SESSION_COUNT_LIMIT = "sessionCountLimit";
    public static final String TRANSPORT = "transport";
    public static final String PORT = "port";
    public static final String MAX_UNCOMMITTED_IN_MEMORY_SIZE = "connection.maxUncommittedInMemorySize";
    @ManagedContextDefault(name="connection.maxUncommittedInMemorySize", description="Defines the maximum limit of total messages sizes (in bytes) from uncommitted transactions which connection can hold in memory. If limit is breached, all messages from connection in-flight transactions are flowed to disk including those arriving after breaching the limit.")
    public static final long DEFAULT_MAX_UNCOMMITTED_IN_MEMORY_SIZE = 0xA00000L;
    public static final String CLOSE_RESPONSE_TIMEOUT = "connection.closeResponseTimeout";
    @ManagedContextDefault(name="connection.closeResponseTimeout")
    public static final long DEFAULT_CLOSE_RESPONSE_TIMEOUT = 2000L;
    public static final String MAX_MESSAGE_SIZE = "qpid.max_message_size";
    @ManagedContextDefault(name="qpid.max_message_size")
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x6400000;

    @DerivedAttribute
    public String getClientId();

    @DerivedAttribute
    public String getClientVersion();

    @DerivedAttribute
    public String getClientProduct();

    @DerivedAttribute
    public boolean isIncoming();

    @DerivedAttribute
    public String getLocalAddress();

    @DerivedAttribute
    public String getPrincipal();

    @DerivedAttribute
    public String getRemoteAddress();

    @DerivedAttribute
    public String getRemoteProcessName();

    @DerivedAttribute
    public String getRemoteProcessPid();

    @DerivedAttribute(description="The actual negotiated value of session count limit")
    public int getSessionCountLimit();

    @DerivedAttribute
    public Transport getTransport();

    @DerivedAttribute
    public String getTransportInfo();

    @DerivedAttribute
    public Protocol getProtocol();

    @DerivedAttribute
    public NamedAddressSpace getAddressSpace();

    @DerivedAttribute
    public Port<?> getPort();

    @DerivedAttribute(description="The maximum size in bytes that uncommitted transactions associated with this connection may grow before the messages contained within the transactions will be flowed to disk.  Disabled if negative.")
    public long getMaxUncommittedInMemorySize();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Inbound", description="Total size of all messages received by this connection.", metricName="inbound_bytes_count", resettable=true)
    public long getBytesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Outbound", description="Total size of all messages delivered by this connection.", metricName="outbound_bytes_count", resettable=true)
    public long getBytesOut();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Inbound", description="Total number of messages delivered by this connection.", metricName="inbound_messages_count", resettable=true)
    public long getMessagesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Outbound", description="Total number of messages received by this connection.", metricName="outbound_messages_count", resettable=true)
    public long getMessagesOut();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.ABSOLUTE_TIME, label="Last I/O time", description="Time of last I/O operation performed by this connection.")
    public Date getLastIoTime();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.ABSOLUTE_TIME, label="Last Inbound Message", description="Time of last message received by the broker on this connection. If no message has been received the connection creation time will be used.", resettable=true)
    public Date getLastInboundMessageTime();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.ABSOLUTE_TIME, label="Last Outbound Message", description="Time of last message sent by the broker on this connection. If no message has been snt the connection creation time will be used.", resettable=true)
    public Date getLastOutboundMessageTime();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.ABSOLUTE_TIME, label="Last Message", description="Time of last message sent or received by the broker on this connection. If no message has been sent or received the connection creation time will be used.", resettable=true)
    public Date getLastMessageTime();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Sessions", description="Current number of sessions belonging to this connection.", metricName="sessions_total")
    public int getSessionCount();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.COUNT, label="Transactions", description="Total number of transactions started.", resettable=true)
    public long getLocalTransactionBegins();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.COUNT, label="Rolled-back Transactions", description="Total number of rolled-back transactions.", resettable=true)
    public long getLocalTransactionRollbacks();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Open Transactions", description="Current number of open transactions.")
    public long getLocalTransactionOpen();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.ABSOLUTE_TIME, label="Oldest transaction start time", description="The start time of the oldest transaction or null if no transaction is in progress.")
    public Date getOldestTransactionStartTime();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Transacted Inbound", description="Total number of messages delivered by this connection within a transaction.", metricName="transacted_inbound_messages_count", resettable=true)
    public long getTransactedMessagesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Transacted Outbound", description="Total number of messages received by this connection within a transaction.", metricName="transacted_outbound_messages_count", resettable=true)
    public long getTransactedMessagesOut();

    @ManagedOperation(description="Resets connection statistics", changesConfiguredObjectState=true)
    public void resetStatistics();

    public Collection<Session> getSessions();
}

