/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import org.apache.qpid.server.model.SystemConfig;

public interface SystemLauncherListener {
    public void beforeStartup();

    public void errorOnStartup(RuntimeException var1);

    public void afterStartup();

    public void onContainerResolve(SystemConfig<?> var1);

    public void onContainerClose(SystemConfig<?> var1);

    public void onShutdown(int var1);

    public void exceptionOnShutdown(Exception var1);

    public static class ChainedSystemLauncherListener
    implements SystemLauncherListener {
        private final SystemLauncherListener[] _listeners;

        public ChainedSystemLauncherListener(SystemLauncherListener ... chain) {
            this._listeners = chain;
        }

        @Override
        public void beforeStartup() {
            for (SystemLauncherListener listener : this._listeners) {
                listener.beforeStartup();
            }
        }

        @Override
        public void errorOnStartup(RuntimeException e) {
            for (SystemLauncherListener listener : this._listeners) {
                listener.errorOnStartup(e);
            }
        }

        @Override
        public void afterStartup() {
            for (SystemLauncherListener listener : this._listeners) {
                listener.afterStartup();
            }
        }

        @Override
        public void onContainerResolve(SystemConfig<?> systemConfig) {
            for (SystemLauncherListener listener : this._listeners) {
                listener.onContainerResolve(systemConfig);
            }
        }

        @Override
        public void onContainerClose(SystemConfig<?> systemConfig) {
            for (SystemLauncherListener listener : this._listeners) {
                listener.onContainerClose(systemConfig);
            }
        }

        @Override
        public void onShutdown(int exitCode) {
            for (SystemLauncherListener listener : this._listeners) {
                listener.onShutdown(exitCode);
            }
        }

        @Override
        public void exceptionOnShutdown(Exception e) {
            for (SystemLauncherListener listener : this._listeners) {
                listener.exceptionOnShutdown(e);
            }
        }
    }

    public static class DefaultSystemLauncherListener
    implements SystemLauncherListener {
        @Override
        public void beforeStartup() {
        }

        @Override
        public void errorOnStartup(RuntimeException e) {
        }

        @Override
        public void afterStartup() {
        }

        @Override
        public void onContainerResolve(SystemConfig<?> systemConfig) {
        }

        @Override
        public void onContainerClose(SystemConfig<?> systemConfig) {
        }

        @Override
        public void onShutdown(int exitCode) {
        }

        @Override
        public void exceptionOnShutdown(Exception e) {
        }
    }
}

