/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.server.protocol.v0_10.FlowCreditManager_0_10;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowCreditManager
implements FlowCreditManager_0_10 {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowCreditManager.class);
    private volatile long _bytesCreditLimit;
    private volatile long _messageCreditLimit;
    private volatile long _bytesUsed;
    private volatile long _messageUsed;

    public WindowCreditManager(long bytesCreditLimit, long messageCreditLimit) {
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
    }

    public synchronized long getMessageCreditLimit() {
        return this._messageCreditLimit;
    }

    synchronized long getMessageCredit() {
        return this._messageCreditLimit == -1L ? Long.MAX_VALUE : (this._messageUsed < this._messageCreditLimit ? this._messageCreditLimit - this._messageUsed : 0L);
    }

    synchronized long getBytesCredit() {
        return this._bytesCreditLimit == -1L ? Long.MAX_VALUE : (this._bytesUsed < this._bytesCreditLimit ? this._bytesCreditLimit - this._bytesUsed : 0L);
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
        if (this._messageCreditLimit >= 0L) {
            this._messageUsed -= messageCredit;
            if (this._messageUsed < 0L) {
                LOGGER.warn("Message credit used value was negative: " + this._messageUsed);
                this._messageUsed = 0L;
            }
        }
        if (this._bytesCreditLimit >= 0L) {
            this._bytesUsed -= bytesCredit;
            if (this._bytesUsed < 0L) {
                LOGGER.warn("Bytes credit used value was negative: " + this._bytesUsed);
                this._bytesUsed = 0L;
            }
        }
    }

    public synchronized boolean hasCredit() {
        return !(this._bytesCreditLimit >= 0L && this._bytesCreditLimit <= this._bytesUsed || this._messageCreditLimit >= 0L && this._messageCreditLimit <= this._messageUsed);
    }

    public synchronized boolean useCreditForMessage(long msgSize) {
        if (this._messageCreditLimit >= 0L) {
            if (this._messageUsed < this._messageCreditLimit) {
                if (this._bytesCreditLimit < 0L) {
                    ++this._messageUsed;
                    return true;
                }
                if (this._bytesUsed + msgSize <= this._bytesCreditLimit) {
                    ++this._messageUsed;
                    this._bytesUsed += msgSize;
                    return true;
                }
                return false;
            }
            return false;
        }
        if (this._bytesCreditLimit >= 0L) {
            if (this._bytesUsed + msgSize <= this._bytesCreditLimit) {
                this._bytesUsed += msgSize;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized void addCredit(long count, long bytes) {
        if (bytes == 0xFFFFFFFFL) {
            this._bytesCreditLimit = -1L;
        } else if (this._bytesCreditLimit >= 0L) {
            this._bytesCreditLimit += bytes;
            if (this._bytesCreditLimit < 0L) {
                LOGGER.warn("Bytes credit wraparound: attempt to add {} bytes credit to existing total of {}", (Object)bytes, (Object)(this._bytesCreditLimit - bytes));
                this._bytesCreditLimit = Long.MAX_VALUE;
            }
        }
        if (count == 0xFFFFFFFFL) {
            this._messageCreditLimit = -1L;
        } else if (this._messageCreditLimit >= 0L) {
            this._messageCreditLimit += count;
            if (this._messageCreditLimit < 0L) {
                LOGGER.warn("Message credit wraparound: attempt to add {} message credit to existing total of {}", (Object)count, (Object)(this._messageCreditLimit - count));
                this._messageCreditLimit = Long.MAX_VALUE;
            }
        }
    }

    @Override
    public synchronized void clearCredit() {
        this._bytesCreditLimit = 0L;
        this._messageCreditLimit = 0L;
    }
}

