/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public abstract class VariableWidthWriter<V>
implements ValueWriter<V> {
    private final int _length;
    private final int _size;

    public VariableWidthWriter(int length) {
        this._length = length;
        this._size = (this._length & 0xFFFFFF00) == 0 ? 1 : 4;
    }

    @Override
    public final void writeToBuffer(QpidByteBuffer buffer) {
        boolean singleOctetSize;
        int length = this.getLength();
        boolean bl = singleOctetSize = this._size == 1;
        if (singleOctetSize) {
            buffer.put(this.getSingleOctetEncodingCode());
            buffer.put((byte)length);
        } else {
            buffer.put(this.getFourOctetEncodingCode());
            buffer.putInt(length);
        }
        this.writeBytes(buffer, 0, length);
    }

    @Override
    public final int getEncodedSize() {
        return 1 + this._size + this.getLength();
    }

    protected abstract byte getFourOctetEncodingCode();

    protected abstract byte getSingleOctetEncodingCode();

    protected final int getLength() {
        return this._length;
    }

    protected abstract void writeBytes(QpidByteBuffer var1, int var2, int var3);
}

