/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.mimecontentconverter.ConversionUtils;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentConverterRegistry;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentToObjectConverter;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.v1_0.JmsMessageTypeAnnotation;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoder;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpSequence;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpSequenceSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValue;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValueSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Data;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.server.protocol.v1_0.type.messaging.NonEncodingRetainingSection;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.GZIPUtils;

public abstract class MessageConverter_to_1_0<M extends ServerMessage>
implements MessageConverter<M, Message_1_0> {
    private static final byte[] SERIALIZED_NULL = MessageConverter_to_1_0.getObjectBytes(null);
    private final AMQPDescribedTypeRegistry _typeRegistry = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer();

    public static Symbol getContentType(String contentMimeType) {
        Object contentType = null;
        if (contentMimeType != null) {
            contentType = ConversionUtils.TEXT_CONTENT_TYPES.matcher(contentMimeType).matches() ? Symbol.valueOf(contentMimeType) : (ConversionUtils.BYTES_MESSAGE_CONTENT_TYPES.matcher(contentMimeType).matches() ? Symbol.valueOf("application/octet-stream") : (ConversionUtils.MAP_MESSAGE_CONTENT_TYPES.matcher(contentMimeType).matches() ? null : (ConversionUtils.LIST_MESSAGE_CONTENT_TYPES.matcher(contentMimeType).matches() ? null : (ConversionUtils.OBJECT_MESSAGE_CONTENT_TYPES.matcher(contentMimeType).matches() ? Symbol.valueOf("application/x-java-serialized-object") : Symbol.valueOf(contentMimeType)))));
        }
        return contentType;
    }

    public static MessageAnnotations createMessageAnnotation(EncodingRetainingSection<?> bodySection, String contentMimeType) {
        MessageAnnotations messageAnnotations = null;
        Symbol key = Symbol.valueOf("x-opt-jms-msg-type");
        if (contentMimeType != null) {
            if (ConversionUtils.TEXT_CONTENT_TYPES.matcher(contentMimeType).matches()) {
                messageAnnotations = new MessageAnnotations(Collections.singletonMap(key, JmsMessageTypeAnnotation.TEXT_MESSAGE.getType()));
            } else if (ConversionUtils.BYTES_MESSAGE_CONTENT_TYPES.matcher(contentMimeType).matches()) {
                messageAnnotations = new MessageAnnotations(Collections.singletonMap(key, JmsMessageTypeAnnotation.BYTES_MESSAGE.getType()));
            } else if (ConversionUtils.MAP_MESSAGE_CONTENT_TYPES.matcher(contentMimeType).matches()) {
                if (MessageConverter_to_1_0.isSectionValidForJmsMap(bodySection)) {
                    messageAnnotations = new MessageAnnotations(Collections.singletonMap(key, JmsMessageTypeAnnotation.MAP_MESSAGE.getType()));
                }
            } else if (ConversionUtils.LIST_MESSAGE_CONTENT_TYPES.matcher(contentMimeType).matches()) {
                if (MessageConverter_to_1_0.isSectionValidForJmsList(bodySection)) {
                    messageAnnotations = new MessageAnnotations(Collections.singletonMap(key, JmsMessageTypeAnnotation.STREAM_MESSAGE.getType()));
                }
            } else if (ConversionUtils.OBJECT_MESSAGE_CONTENT_TYPES.matcher(contentMimeType).matches()) {
                messageAnnotations = new MessageAnnotations(Collections.singletonMap(key, JmsMessageTypeAnnotation.OBJECT_MESSAGE.getType()));
            }
        } else if (bodySection instanceof AmqpValueSection && bodySection.getValue() == null) {
            messageAnnotations = new MessageAnnotations(Collections.singletonMap(key, JmsMessageTypeAnnotation.MESSAGE.getType()));
        }
        return messageAnnotations;
    }

    public static boolean isSectionValidForJmsList(EncodingRetainingSection<?> section) {
        if (section instanceof AmqpSequenceSection) {
            List list = (List)((AmqpSequenceSection)section).getValue();
            for (Object entry : list) {
                if (entry == null || entry instanceof Boolean || entry instanceof Byte || entry instanceof Short || entry instanceof Integer || entry instanceof Long || entry instanceof Float || entry instanceof Double || entry instanceof Character || entry instanceof String || entry instanceof Binary) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isSectionValidForJmsMap(EncodingRetainingSection<?> section) {
        Object valueObject;
        if (section instanceof AmqpValueSection && (valueObject = ((AmqpValueSection)section).getValue()) instanceof Map) {
            Map map = (Map)valueObject;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    return false;
                }
                Object value = entry.getValue();
                if (value == null || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value instanceof Binary) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final Class<Message_1_0> getOutputClass() {
        return Message_1_0.class;
    }

    public final Message_1_0 convert(M message, NamedAddressSpace addressSpace) {
        SectionEncoderImpl sectionEncoder = new SectionEncoderImpl(this._typeRegistry);
        return new Message_1_0(this.convertToStoredMessage(message, sectionEncoder));
    }

    public void dispose(Message_1_0 message) {
        if (message.getStoredMessage() instanceof ConvertedMessage) {
            ((ConvertedMessage)message.getStoredMessage()).dispose();
        }
    }

    private ConvertedMessage<M> convertToStoredMessage(M serverMessage, SectionEncoder sectionEncoder) {
        EncodingRetainingSection<?> bodySection = this.getBodySection(serverMessage, sectionEncoder);
        MessageMetaData_1_0 metaData = this.convertMetaData(serverMessage, bodySection, sectionEncoder);
        return this.convertServerMessage(metaData, serverMessage, bodySection);
    }

    protected abstract MessageMetaData_1_0 convertMetaData(M var1, EncodingRetainingSection<?> var2, SectionEncoder var3);

    private static NonEncodingRetainingSection<?> convertMessageBody(String mimeType, byte[] data) {
        if (data != null && data.length != 0) {
            MimeContentToObjectConverter converter = MimeContentConverterRegistry.getMimeContentToObjectConverter((String)mimeType);
            if (converter != null) {
                Object bodyObject = converter.toObject(data);
                if (bodyObject instanceof String) {
                    return new AmqpValue(bodyObject);
                }
                if (bodyObject instanceof Map) {
                    return new AmqpValue(MessageConverter_to_1_0.fixMapValues((Map)bodyObject));
                }
                if (bodyObject instanceof List) {
                    return new AmqpSequence(MessageConverter_to_1_0.fixListValues((List)bodyObject));
                }
            } else if (mimeType != null && ConversionUtils.TEXT_CONTENT_TYPES.matcher(mimeType).matches()) {
                return new AmqpValue(new String(data, StandardCharsets.UTF_8));
            }
        } else {
            if (mimeType == null) {
                return new AmqpValue(null);
            }
            if (ConversionUtils.OBJECT_MESSAGE_CONTENT_TYPES.matcher(mimeType).matches()) {
                return new Data(new Binary(SERIALIZED_NULL));
            }
            if (ConversionUtils.TEXT_CONTENT_TYPES.matcher(mimeType).matches()) {
                return new AmqpValue("");
            }
            if (ConversionUtils.MAP_MESSAGE_CONTENT_TYPES.matcher(mimeType).matches()) {
                return new AmqpValue(Collections.emptyMap());
            }
            if (ConversionUtils.LIST_MESSAGE_CONTENT_TYPES.matcher(mimeType).matches()) {
                return new AmqpSequence(Collections.emptyList());
            }
        }
        return new Data(new Binary(data));
    }

    static Map<String, Object> fixMapValues(Map<String, Object> map) {
        map = new LinkedHashMap<String, Object>(map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            entry.setValue(MessageConverter_to_1_0.fixValue(entry.getValue()));
        }
        return map;
    }

    static Object fixValue(Object value) {
        if (value instanceof byte[]) {
            return new Binary((byte[])value);
        }
        if (value instanceof Map) {
            return MessageConverter_to_1_0.fixMapValues((Map)value);
        }
        if (value instanceof List) {
            return MessageConverter_to_1_0.fixListValues((List)value);
        }
        return value;
    }

    static List<Object> fixListValues(List<Object> list) {
        list = new ArrayList<Object>(list);
        ListIterator<Object> iterator = list.listIterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            iterator.set(MessageConverter_to_1_0.fixValue(value));
        }
        return list;
    }

    private ConvertedMessage<M> convertServerMessage(MessageMetaData_1_0 metaData, M serverMessage, EncodingRetainingSection<?> section) {
        return new ConvertedMessage<M>(metaData, serverMessage, section);
    }

    protected EncodingRetainingSection<?> getBodySection(M serverMessage, SectionEncoder encoder) {
        byte[] uncompressed;
        String mimeType = serverMessage.getMessageHeader().getMimeType();
        byte[] data = new byte[(int)serverMessage.getSize()];
        try (QpidByteBuffer content = serverMessage.getContent();){
            content.get(data);
        }
        if ("gzip".equals(serverMessage.getMessageHeader().getEncoding()) && (uncompressed = GZIPUtils.uncompressBufferToArray((ByteBuffer)ByteBuffer.wrap(data))) != null) {
            data = uncompressed;
        }
        return MessageConverter_to_1_0.convertMessageBody(mimeType, data).createEncodingRetainingSection();
    }

    private static byte[] getObjectBytes(Object object) {
        byte[] expected;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
            expected = baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return expected;
    }

    private static class ConvertedMessage<M extends ServerMessage>
    implements StoredMessage<MessageMetaData_1_0> {
        private final MessageMetaData_1_0 _metaData;
        private final M _serverMessage;
        private final EncodingRetainingSection<?> _section;

        public ConvertedMessage(MessageMetaData_1_0 metaData, M serverMessage, EncodingRetainingSection<?> section) {
            this._metaData = metaData;
            this._serverMessage = serverMessage;
            this._section = section;
        }

        public MessageMetaData_1_0 getMetaData() {
            return this._metaData;
        }

        public long getMessageNumber() {
            return this._serverMessage.getMessageNumber();
        }

        public QpidByteBuffer getContent(int offset, int length) {
            try (QpidByteBuffer content = this._section.getEncodedForm();){
                QpidByteBuffer qpidByteBuffer = content.view(offset, length);
                return qpidByteBuffer;
            }
        }

        public int getContentSize() {
            return this._metaData.getContentSize();
        }

        public int getMetadataSize() {
            return this._metaData.getStorableSize();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean isInContentInMemory() {
            return true;
        }

        public long getInMemorySize() {
            return this.getContentSize() + this.getMetadataSize();
        }

        public boolean flowToDisk() {
            return false;
        }

        public void reallocate() {
        }

        private void dispose() {
            this._section.dispose();
            this._metaData.dispose();
        }
    }
}

