/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.Collection;
import java.util.function.Supplier;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthorityAuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.Assert;

public final class AuthoritiesAuthorizationManager
implements AuthorizationManager<Collection<String>> {
    private RoleHierarchy roleHierarchy = new NullRoleHierarchy();

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        Assert.notNull((Object)roleHierarchy, (String)"roleHierarchy cannot be null");
        this.roleHierarchy = roleHierarchy;
    }

    public AuthorityAuthorizationDecision check(Supplier<Authentication> authentication, Collection<String> authorities) {
        boolean granted = this.isGranted(authentication.get(), authorities);
        return new AuthorityAuthorizationDecision(granted, AuthorityUtils.createAuthorityList(authorities));
    }

    private boolean isGranted(Authentication authentication, Collection<String> authorities) {
        return authentication != null && this.isAuthorized(authentication, authorities);
    }

    private boolean isAuthorized(Authentication authentication, Collection<String> authorities) {
        for (GrantedAuthority grantedAuthority : this.getGrantedAuthorities(authentication)) {
            if (!authorities.contains(grantedAuthority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    private Collection<? extends GrantedAuthority> getGrantedAuthorities(Authentication authentication) {
        return this.roleHierarchy.getReachableGrantedAuthorities(authentication.getAuthorities());
    }
}

