/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.interceptor;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.internal.interceptor.TracingSystemSetting;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.SystemSetting;
import software.amazon.awssdk.utilslite.SdkInternalThreadLocal;

@SdkProtectedApi
public class TraceIdExecutionInterceptor
implements ExecutionInterceptor {
    private static final String TRACE_ID_HEADER = "X-Amzn-Trace-Id";
    private static final String LAMBDA_FUNCTION_NAME_ENVIRONMENT_VARIABLE = "AWS_LAMBDA_FUNCTION_NAME";
    private static final String CONCURRENT_TRACE_ID_KEY = "AWS_LAMBDA_X_TRACE_ID";
    private static final ExecutionAttribute<String> TRACE_ID = new ExecutionAttribute("TraceId");

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        String traceId;
        if (this.lambdaFunctionNameEnvironmentVariable().isPresent() && (traceId = SdkInternalThreadLocal.get((String)CONCURRENT_TRACE_ID_KEY)) != null) {
            executionAttributes.putAttribute(TRACE_ID, (Object)traceId);
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Optional<String> traceIdHeader = this.traceIdHeader(context);
        if (!traceIdHeader.isPresent()) {
            Optional<String> lambdafunctionName = this.lambdaFunctionNameEnvironmentVariable();
            Optional<String> traceId = this.traceId(executionAttributes);
            if (lambdafunctionName.isPresent() && traceId.isPresent()) {
                return (SdkHttpRequest)context.httpRequest().copy(r -> r.putHeader(TRACE_ID_HEADER, (String)traceId.get()));
            }
        }
        return context.httpRequest();
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        if (this.lambdaFunctionNameEnvironmentVariable().isPresent()) {
            TraceIdExecutionInterceptor.saveTraceId(executionAttributes);
        }
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        if (this.lambdaFunctionNameEnvironmentVariable().isPresent()) {
            TraceIdExecutionInterceptor.saveTraceId(executionAttributes);
        }
    }

    private static void saveTraceId(ExecutionAttributes executionAttributes) {
        String traceId = (String)executionAttributes.getAttribute(TRACE_ID);
        if (traceId != null) {
            SdkInternalThreadLocal.put((String)CONCURRENT_TRACE_ID_KEY, (String)((String)executionAttributes.getAttribute(TRACE_ID)));
        }
    }

    private Optional<String> traceIdHeader(Context.ModifyHttpRequest context) {
        return context.httpRequest().firstMatchingHeader(TRACE_ID_HEADER);
    }

    private Optional<String> traceId(ExecutionAttributes executionAttributes) {
        Optional<String> traceId = Optional.ofNullable((String)executionAttributes.getAttribute(TRACE_ID));
        if (traceId.isPresent()) {
            return traceId;
        }
        return TracingSystemSetting._X_AMZN_TRACE_ID.getStringValue();
    }

    private Optional<String> lambdaFunctionNameEnvironmentVariable() {
        return SystemSetting.getStringValueFromEnvironmentVariable((String)LAMBDA_FUNCTION_NAME_ENVIRONMENT_VARIABLE);
    }
}

