/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javap;

import java.util.Collection;
import jpt.sun.tools.classfile.AccessFlags;
import jpt.sun.tools.classfile.AnnotationDefault_attribute;
import jpt.sun.tools.classfile.Attribute;
import jpt.sun.tools.classfile.Attributes;
import jpt.sun.tools.classfile.BootstrapMethods_attribute;
import jpt.sun.tools.classfile.CharacterRangeTable_attribute;
import jpt.sun.tools.classfile.Code_attribute;
import jpt.sun.tools.classfile.CompilationID_attribute;
import jpt.sun.tools.classfile.ConstantPool;
import jpt.sun.tools.classfile.ConstantPoolException;
import jpt.sun.tools.classfile.ConstantValue_attribute;
import jpt.sun.tools.classfile.DefaultAttribute;
import jpt.sun.tools.classfile.Deprecated_attribute;
import jpt.sun.tools.classfile.Descriptor;
import jpt.sun.tools.classfile.EnclosingMethod_attribute;
import jpt.sun.tools.classfile.Exceptions_attribute;
import jpt.sun.tools.classfile.InnerClasses_attribute;
import jpt.sun.tools.classfile.LineNumberTable_attribute;
import jpt.sun.tools.classfile.LocalVariableTable_attribute;
import jpt.sun.tools.classfile.LocalVariableTypeTable_attribute;
import jpt.sun.tools.classfile.MethodParameters_attribute;
import jpt.sun.tools.classfile.ModuleHashes_attribute;
import jpt.sun.tools.classfile.ModuleMainClass_attribute;
import jpt.sun.tools.classfile.ModulePackages_attribute;
import jpt.sun.tools.classfile.ModuleResolution_attribute;
import jpt.sun.tools.classfile.ModuleTarget_attribute;
import jpt.sun.tools.classfile.Module_attribute;
import jpt.sun.tools.classfile.NestHost_attribute;
import jpt.sun.tools.classfile.NestMembers_attribute;
import jpt.sun.tools.classfile.PermittedSubclasses_attribute;
import jpt.sun.tools.classfile.Record_attribute;
import jpt.sun.tools.classfile.RuntimeInvisibleAnnotations_attribute;
import jpt.sun.tools.classfile.RuntimeInvisibleParameterAnnotations_attribute;
import jpt.sun.tools.classfile.RuntimeInvisibleTypeAnnotations_attribute;
import jpt.sun.tools.classfile.RuntimeParameterAnnotations_attribute;
import jpt.sun.tools.classfile.RuntimeVisibleAnnotations_attribute;
import jpt.sun.tools.classfile.RuntimeVisibleParameterAnnotations_attribute;
import jpt.sun.tools.classfile.RuntimeVisibleTypeAnnotations_attribute;
import jpt.sun.tools.classfile.Signature_attribute;
import jpt.sun.tools.classfile.SourceDebugExtension_attribute;
import jpt.sun.tools.classfile.SourceFile_attribute;
import jpt.sun.tools.classfile.SourceID_attribute;
import jpt.sun.tools.classfile.StackMapTable_attribute;
import jpt.sun.tools.classfile.StackMap_attribute;
import jpt.sun.tools.classfile.Synthetic_attribute;
import jpt.sun.tools.classfile.Type;
import jpt.sun.tools.javac.util.Assert;
import jpt.sun.tools.javac.util.StringUtils;
import jpt.sun.tools.javap.AnnotationWriter;
import jpt.sun.tools.javap.BasicWriter;
import jpt.sun.tools.javap.CodeWriter;
import jpt.sun.tools.javap.ConstantWriter;
import jpt.sun.tools.javap.Context;
import jpt.sun.tools.javap.Options;

public class AttributeWriter
extends BasicWriter
implements Attribute.Visitor<Void, Void> {
    private static final String format = "%-31s%s";
    private final AnnotationWriter annotationWriter;
    private final CodeWriter codeWriter;
    private final ConstantWriter constantWriter;
    private final Options options;
    private ConstantPool constant_pool;
    private Object owner;

    public static AttributeWriter instance(Context context) {
        AttributeWriter instance = context.get(AttributeWriter.class);
        if (instance == null) {
            instance = new AttributeWriter(context);
        }
        return instance;
    }

    protected AttributeWriter(Context context) {
        super(context);
        context.put(AttributeWriter.class, this);
        this.annotationWriter = AnnotationWriter.instance(context);
        this.codeWriter = CodeWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
        this.options = Options.instance(context);
    }

    public void write(Object owner, Attribute attr, ConstantPool constant_pool) {
        if (attr != null) {
            Assert.checkNonNull(constant_pool);
            Assert.checkNonNull(owner);
            this.constant_pool = constant_pool;
            this.owner = owner;
            attr.accept(this, null);
        }
    }

    public void write(Object owner, Attributes attrs, ConstantPool constant_pool) {
        if (attrs != null) {
            Assert.checkNonNull(constant_pool);
            Assert.checkNonNull(owner);
            this.constant_pool = constant_pool;
            this.owner = owner;
            for (Attribute attr : attrs) {
                attr.accept(this, null);
            }
        }
    }

    @Override
    public Void visitDefault(DefaultAttribute attr, Void ignore) {
        byte[] data = attr.info;
        int i = 0;
        int j = 0;
        this.print("  ");
        try {
            this.print(attr.getName(this.constant_pool));
        }
        catch (ConstantPoolException e) {
            this.report(e);
            this.print("attribute name = #" + attr.attribute_name_index);
        }
        this.print(": ");
        this.print("length = 0x" + AttributeWriter.toHex(attr.info.length));
        if (attr.reason != null) {
            this.print(" (" + attr.reason + ")");
        }
        this.println();
        this.print("   ");
        while (i < data.length) {
            this.print(this.toHex(data[i], 2));
            if (++j == 16) {
                this.println();
                this.print("   ");
                j = 0;
            } else {
                this.print(" ");
            }
            ++i;
        }
        this.println();
        return null;
    }

    @Override
    public Void visitAnnotationDefault(AnnotationDefault_attribute attr, Void ignore) {
        this.println("AnnotationDefault:");
        this.indent(1);
        this.print("default_value: ");
        this.annotationWriter.write(attr.default_value);
        this.indent(-1);
        this.println();
        return null;
    }

    @Override
    public Void visitBootstrapMethods(BootstrapMethods_attribute attr, Void p) {
        this.println("BootstrapMethods:");
        for (int i = 0; i < attr.bootstrap_method_specifiers.length; ++i) {
            BootstrapMethods_attribute.BootstrapMethodSpecifier bsm = attr.bootstrap_method_specifiers[i];
            this.indent(1);
            this.print(i + ": #" + bsm.bootstrap_method_ref + " ");
            this.println(this.constantWriter.stringValue(bsm.bootstrap_method_ref));
            this.indent(1);
            this.println("Method arguments:");
            this.indent(1);
            for (int j = 0; j < bsm.bootstrap_arguments.length; ++j) {
                this.print("#" + bsm.bootstrap_arguments[j] + " ");
                this.println(this.constantWriter.stringValue(bsm.bootstrap_arguments[j]));
            }
            this.indent(-3);
        }
        return null;
    }

    @Override
    public Void visitCharacterRangeTable(CharacterRangeTable_attribute attr, Void ignore) {
        this.println("CharacterRangeTable:");
        this.indent(1);
        for (CharacterRangeTable_attribute.Entry e : attr.character_range_table) {
            this.print(String.format("    %2d, %2d, %6x, %6x, %4x", e.start_pc, e.end_pc, e.character_range_start, e.character_range_end, e.flags));
            this.tab();
            this.print(String.format("// %2d, %2d, %4d:%02d, %4d:%02d", e.start_pc, e.end_pc, e.character_range_start >> 10, e.character_range_start & 0x3FF, e.character_range_end >> 10, e.character_range_end & 0x3FF));
            if ((e.flags & 1) != 0) {
                this.print(", statement");
            }
            if ((e.flags & 2) != 0) {
                this.print(", block");
            }
            if ((e.flags & 4) != 0) {
                this.print(", assignment");
            }
            if ((e.flags & 8) != 0) {
                this.print(", flow-controller");
            }
            if ((e.flags & 0x10) != 0) {
                this.print(", flow-target");
            }
            if ((e.flags & 0x20) != 0) {
                this.print(", invoke");
            }
            if ((e.flags & 0x40) != 0) {
                this.print(", create");
            }
            if ((e.flags & 0x80) != 0) {
                this.print(", branch-true");
            }
            if ((e.flags & 0x100) != 0) {
                this.print(", branch-false");
            }
            this.println();
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitCode(Code_attribute attr, Void ignore) {
        this.codeWriter.write(attr, this.constant_pool);
        return null;
    }

    @Override
    public Void visitCompilationID(CompilationID_attribute attr, Void ignore) {
        this.constantWriter.write(attr.compilationID_index);
        return null;
    }

    @Override
    public Void visitConstantValue(ConstantValue_attribute attr, Void ignore) {
        this.print("ConstantValue: ");
        this.constantWriter.write(attr.constantvalue_index);
        this.println();
        return null;
    }

    @Override
    public Void visitDeprecated(Deprecated_attribute attr, Void ignore) {
        this.println("Deprecated: true");
        return null;
    }

    @Override
    public Void visitEnclosingMethod(EnclosingMethod_attribute attr, Void ignore) {
        this.print("EnclosingMethod: #" + attr.class_index + ".#" + attr.method_index);
        this.tab();
        this.print("// " + this.getJavaClassName(attr));
        if (attr.method_index != 0) {
            this.print("." + this.getMethodName(attr));
        }
        this.println();
        return null;
    }

    private String getJavaClassName(EnclosingMethod_attribute a) {
        try {
            return AttributeWriter.getJavaName(a.getClassName(this.constant_pool));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    private String getMethodName(EnclosingMethod_attribute a) {
        try {
            return a.getMethodName(this.constant_pool);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    @Override
    public Void visitExceptions(Exceptions_attribute attr, Void ignore) {
        this.println("Exceptions:");
        this.indent(1);
        this.print("throws ");
        for (int i = 0; i < attr.number_of_exceptions; ++i) {
            if (i > 0) {
                this.print(", ");
            }
            this.print(this.getJavaException(attr, i));
        }
        this.println();
        this.indent(-1);
        return null;
    }

    private String getJavaException(Exceptions_attribute attr, int index) {
        try {
            return AttributeWriter.getJavaName(attr.getException(index, this.constant_pool));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    @Override
    public Void visitInnerClasses(InnerClasses_attribute attr, Void ignore) {
        boolean first = true;
        for (InnerClasses_attribute.Info info : attr.classes) {
            AccessFlags access_flags = info.inner_class_access_flags;
            if (!this.options.checkAccess(access_flags)) continue;
            if (first) {
                this.writeInnerClassHeader();
                first = false;
            }
            for (String name : access_flags.getInnerClassModifiers()) {
                this.print(name + " ");
            }
            if (info.inner_name_index != 0) {
                this.print("#" + info.inner_name_index + "= ");
            }
            this.print("#" + info.inner_class_info_index);
            if (info.outer_class_info_index != 0) {
                this.print(" of #" + info.outer_class_info_index);
            }
            this.print(";");
            this.tab();
            this.print("// ");
            if (info.inner_name_index != 0) {
                this.print(this.getInnerName(this.constant_pool, info) + "=");
            }
            this.constantWriter.write(info.inner_class_info_index);
            if (info.outer_class_info_index != 0) {
                this.print(" of ");
                this.constantWriter.write(info.outer_class_info_index);
            }
            this.println();
        }
        if (!first) {
            this.indent(-1);
        }
        return null;
    }

    String getInnerName(ConstantPool constant_pool, InnerClasses_attribute.Info info) {
        try {
            return info.getInnerName(constant_pool);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    private void writeInnerClassHeader() {
        this.println("InnerClasses:");
        this.indent(1);
    }

    @Override
    public Void visitLineNumberTable(LineNumberTable_attribute attr, Void ignore) {
        this.println("LineNumberTable:");
        this.indent(1);
        for (LineNumberTable_attribute.Entry entry : attr.line_number_table) {
            this.println("line " + entry.line_number + ": " + entry.start_pc);
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitLocalVariableTable(LocalVariableTable_attribute attr, Void ignore) {
        this.println("LocalVariableTable:");
        this.indent(1);
        this.println("Start  Length  Slot  Name   Signature");
        for (LocalVariableTable_attribute.Entry entry : attr.local_variable_table) {
            this.println(String.format("%5d %7d %5d %5s   %s", entry.start_pc, entry.length, entry.index, this.constantWriter.stringValue(entry.name_index), this.constantWriter.stringValue(entry.descriptor_index)));
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitLocalVariableTypeTable(LocalVariableTypeTable_attribute attr, Void ignore) {
        this.println("LocalVariableTypeTable:");
        this.indent(1);
        this.println("Start  Length  Slot  Name   Signature");
        for (LocalVariableTypeTable_attribute.Entry entry : attr.local_variable_table) {
            this.println(String.format("%5d %7d %5d %5s   %s", entry.start_pc, entry.length, entry.index, this.constantWriter.stringValue(entry.name_index), this.constantWriter.stringValue(entry.signature_index)));
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitNestHost(NestHost_attribute attr, Void aVoid) {
        this.print("NestHost: ");
        this.constantWriter.write(attr.top_index);
        this.println();
        return null;
    }

    private String getJavaClassName(ModuleMainClass_attribute a) {
        try {
            return AttributeWriter.getJavaName(a.getMainClassName(this.constant_pool));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    @Override
    public Void visitMethodParameters(MethodParameters_attribute attr, Void ignore) {
        String header = String.format(format, "Name", "Flags");
        this.println("MethodParameters:");
        this.indent(1);
        this.println(header);
        for (MethodParameters_attribute.Entry entry : attr.method_parameter_table) {
            String namestr = entry.name_index != 0 ? this.constantWriter.stringValue(entry.name_index) : "<no name>";
            String flagstr = (0 != (entry.flags & 0x10) ? "final " : "") + (0 != (entry.flags & 0x8000) ? "mandated " : "") + (0 != (entry.flags & 0x1000) ? "synthetic" : "");
            this.println(String.format(format, namestr, flagstr));
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitModule(Module_attribute attr, Void ignore) {
        this.println("Module:");
        this.indent(1);
        this.print("#" + attr.module_name);
        this.print(",");
        this.print(String.format("%x", attr.module_flags));
        this.tab();
        this.print("// " + this.constantWriter.stringValue(attr.module_name));
        if ((attr.module_flags & 0x20) != 0) {
            this.print(" ACC_OPEN");
        }
        if ((attr.module_flags & 0x8000) != 0) {
            this.print(" ACC_MANDATED");
        }
        if ((attr.module_flags & 0x1000) != 0) {
            this.print(" ACC_SYNTHETIC");
        }
        this.println();
        this.print("#" + attr.module_version_index);
        if (attr.module_version_index != 0) {
            this.tab();
            this.print("// " + this.constantWriter.stringValue(attr.module_version_index));
        }
        this.println();
        this.printRequiresTable(attr);
        this.printExportsTable(attr);
        this.printOpensTable(attr);
        this.printUsesTable(attr);
        this.printProvidesTable(attr);
        this.indent(-1);
        return null;
    }

    protected void printRequiresTable(Module_attribute attr) {
        Module_attribute.RequiresEntry[] entries = attr.requires;
        this.print(entries.length);
        this.tab();
        this.println("// requires");
        this.indent(1);
        for (Module_attribute.RequiresEntry e : entries) {
            this.print("#" + e.requires_index + "," + String.format("%x", e.requires_flags));
            this.tab();
            this.print("// " + this.constantWriter.stringValue(e.requires_index));
            if ((e.requires_flags & 0x20) != 0) {
                this.print(" ACC_TRANSITIVE");
            }
            if ((e.requires_flags & 0x40) != 0) {
                this.print(" ACC_STATIC_PHASE");
            }
            if ((e.requires_flags & 0x1000) != 0) {
                this.print(" ACC_SYNTHETIC");
            }
            if ((e.requires_flags & 0x8000) != 0) {
                this.print(" ACC_MANDATED");
            }
            this.println();
            this.print("#" + e.requires_version_index);
            if (e.requires_version_index != 0) {
                this.tab();
                this.print("// " + this.constantWriter.stringValue(e.requires_version_index));
            }
            this.println();
        }
        this.indent(-1);
    }

    protected void printExportsTable(Module_attribute attr) {
        Module_attribute.ExportsEntry[] entries = attr.exports;
        this.print(entries.length);
        this.tab();
        this.println("// exports");
        this.indent(1);
        for (Module_attribute.ExportsEntry e : entries) {
            this.printExportOpenEntry(e.exports_index, e.exports_flags, e.exports_to_index);
        }
        this.indent(-1);
    }

    protected void printOpensTable(Module_attribute attr) {
        Module_attribute.OpensEntry[] entries = attr.opens;
        this.print(entries.length);
        this.tab();
        this.println("// opens");
        this.indent(1);
        for (Module_attribute.OpensEntry e : entries) {
            this.printExportOpenEntry(e.opens_index, e.opens_flags, e.opens_to_index);
        }
        this.indent(-1);
    }

    protected void printExportOpenEntry(int index, int flags, int[] to_index) {
        this.print("#" + index + "," + String.format("%x", flags));
        this.tab();
        this.print("// ");
        this.print(this.constantWriter.stringValue(index));
        if ((flags & 0x8000) != 0) {
            this.print(" ACC_MANDATED");
        }
        if ((flags & 0x1000) != 0) {
            this.print(" ACC_SYNTHETIC");
        }
        if (to_index.length == 0) {
            this.println();
        } else {
            this.println(" to ... " + to_index.length);
            this.indent(1);
            for (int to : to_index) {
                this.print("#" + to);
                this.tab();
                this.println("// ... to " + this.constantWriter.stringValue(to));
            }
            this.indent(-1);
        }
    }

    protected void printUsesTable(Module_attribute attr) {
        int[] entries = attr.uses_index;
        this.print(entries.length);
        this.tab();
        this.println("// uses");
        this.indent(1);
        for (int e : entries) {
            this.print("#" + e);
            this.tab();
            this.println("// " + this.constantWriter.stringValue(e));
        }
        this.indent(-1);
    }

    protected void printProvidesTable(Module_attribute attr) {
        Module_attribute.ProvidesEntry[] entries = attr.provides;
        this.print(entries.length);
        this.tab();
        this.println("// provides");
        this.indent(1);
        for (Module_attribute.ProvidesEntry e : entries) {
            this.print("#" + e.provides_index);
            this.tab();
            this.print("// ");
            this.print(this.constantWriter.stringValue(e.provides_index));
            this.println(" with ... " + e.with_count);
            this.indent(1);
            for (int with : e.with_index) {
                this.print("#" + with);
                this.tab();
                this.println("// ... with " + this.constantWriter.stringValue(with));
            }
            this.indent(-1);
        }
        this.indent(-1);
    }

    @Override
    public Void visitModuleHashes(ModuleHashes_attribute attr, Void ignore) {
        this.println("ModuleHashes:");
        this.indent(1);
        this.print("algorithm: #" + attr.algorithm_index);
        this.tab();
        this.println("// " + this.getAlgorithm(attr));
        this.print(attr.hashes_table_length);
        this.tab();
        this.println("// hashes");
        for (ModuleHashes_attribute.Entry e : attr.hashes_table) {
            this.print("#" + e.module_name_index);
            this.tab();
            this.println("// " + this.getModuleName(e));
            this.println("hash_length: " + e.hash.length);
            this.println("hash: [" + AttributeWriter.toHex(e.hash) + "]");
        }
        this.indent(-1);
        return null;
    }

    private String getAlgorithm(ModuleHashes_attribute attr) {
        try {
            return this.constant_pool.getUTF8Value(attr.algorithm_index);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    private String getModuleName(ModuleHashes_attribute.Entry entry) {
        try {
            int utf8Index = this.constant_pool.getModuleInfo((int)entry.module_name_index).name_index;
            return this.constant_pool.getUTF8Value(utf8Index);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    @Override
    public Void visitModuleMainClass(ModuleMainClass_attribute attr, Void ignore) {
        this.print("ModuleMainClass: #" + attr.main_class_index);
        this.tab();
        this.print("// " + this.getJavaClassName(attr));
        this.println();
        return null;
    }

    @Override
    public Void visitModulePackages(ModulePackages_attribute attr, Void ignore) {
        this.println("ModulePackages: ");
        this.indent(1);
        for (int i = 0; i < attr.packages_count; ++i) {
            this.print("#" + attr.packages_index[i]);
            this.tab();
            this.println("// " + this.getJavaPackage(attr, i));
        }
        this.indent(-1);
        return null;
    }

    private String getJavaPackage(ModulePackages_attribute attr, int index) {
        try {
            return AttributeWriter.getJavaName(attr.getPackage(index, this.constant_pool));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    @Override
    public Void visitModuleResolution(ModuleResolution_attribute attr, Void ignore) {
        this.println("ModuleResolution:");
        this.indent(1);
        this.print(String.format("%x", attr.resolution_flags));
        this.tab();
        this.print("// ");
        int flags = attr.resolution_flags;
        if ((flags & 1) != 0) {
            this.print(" DO_NOT_RESOLVE_BY_DEFAULT");
        }
        if ((flags & 2) != 0) {
            this.print(" WARN_DEPRECATED");
        }
        if ((flags & 4) != 0) {
            this.print(" WARN_DEPRECATED_FOR_REMOVAL");
        }
        if ((flags & 8) != 0) {
            this.print(" WARN_INCUBATING");
        }
        this.println();
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitModuleTarget(ModuleTarget_attribute attr, Void ignore) {
        this.println("ModuleTarget:");
        this.indent(1);
        this.print("target_platform: #" + attr.target_platform_index);
        if (attr.target_platform_index != 0) {
            this.tab();
            this.print("// " + this.getTargetPlatform(attr));
        }
        this.println();
        this.indent(-1);
        return null;
    }

    private String getTargetPlatform(ModuleTarget_attribute attr) {
        try {
            return this.constant_pool.getUTF8Value(attr.target_platform_index);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    @Override
    public Void visitNestMembers(NestMembers_attribute attr, Void aVoid) {
        this.println("NestMembers:");
        this.indent(1);
        try {
            ConstantPool.CONSTANT_Class_info[] children = attr.getChildren(this.constant_pool);
            for (int i = 0; i < attr.members_indexes.length; ++i) {
                this.println(this.constantWriter.stringValue(children[i]));
            }
            this.indent(-1);
        }
        catch (ConstantPoolException ex) {
            throw new AssertionError((Object)ex);
        }
        return null;
    }

    @Override
    public Void visitRecord(Record_attribute attr, Void p) {
        this.println("Record:");
        this.indent(1);
        for (Record_attribute.ComponentInfo componentInfo : attr.component_info_arr) {
            Signature_attribute sigAttr = (Signature_attribute)componentInfo.attributes.get("Signature");
            if (sigAttr == null) {
                this.print(this.getJavaFieldType(componentInfo.descriptor));
            } else {
                try {
                    Type t = sigAttr.getParsedSignature().getType(this.constant_pool);
                    this.print(AttributeWriter.getJavaName(t.toString()));
                }
                catch (ConstantPoolException e) {
                    this.print(this.getJavaFieldType(componentInfo.descriptor));
                }
            }
            this.print(" ");
            try {
                this.print(componentInfo.getName(this.constant_pool));
            }
            catch (ConstantPoolException e) {
                this.report(e);
                return null;
            }
            this.print(";");
            this.println();
            this.indent(1);
            if (this.options.showDescriptors) {
                this.println("descriptor: " + this.getValue(componentInfo.descriptor));
            }
            if (this.options.showAllAttrs) {
                for (Attribute componentAttr : componentInfo.attributes) {
                    this.write((Object)componentInfo, componentAttr, this.constant_pool);
                }
                this.println();
            }
            this.indent(-1);
        }
        this.indent(-1);
        return null;
    }

    String getValue(Descriptor d) {
        try {
            return d.getValue(this.constant_pool);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    void writeList(String prefix, Collection<?> items, String suffix) {
        this.print(prefix);
        String sep = "";
        for (Object item : items) {
            this.print(sep);
            this.print(item);
            sep = ", ";
        }
        this.print(suffix);
    }

    String getJavaFieldType(Descriptor d) {
        try {
            return AttributeWriter.getJavaName(d.getFieldType(this.constant_pool));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
        catch (Descriptor.InvalidDescriptor e) {
            return this.report(e);
        }
    }

    void writeModifiers(Collection<String> items) {
        for (String item : items) {
            this.print((Object)item);
            this.print(" ");
        }
    }

    @Override
    public Void visitRuntimeVisibleAnnotations(RuntimeVisibleAnnotations_attribute attr, Void ignore) {
        this.println("RuntimeVisibleAnnotations:");
        this.indent(1);
        for (int i = 0; i < attr.annotations.length; ++i) {
            this.print(i + ": ");
            this.annotationWriter.write(attr.annotations[i]);
            this.println();
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitRuntimeInvisibleAnnotations(RuntimeInvisibleAnnotations_attribute attr, Void ignore) {
        this.println("RuntimeInvisibleAnnotations:");
        this.indent(1);
        for (int i = 0; i < attr.annotations.length; ++i) {
            this.print(i + ": ");
            this.annotationWriter.write(attr.annotations[i]);
            this.println();
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitRuntimeVisibleTypeAnnotations(RuntimeVisibleTypeAnnotations_attribute attr, Void ignore) {
        this.println("RuntimeVisibleTypeAnnotations:");
        this.indent(1);
        for (int i = 0; i < attr.annotations.length; ++i) {
            this.print(i + ": ");
            this.annotationWriter.write(attr.annotations[i]);
            this.println();
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitRuntimeInvisibleTypeAnnotations(RuntimeInvisibleTypeAnnotations_attribute attr, Void ignore) {
        this.println("RuntimeInvisibleTypeAnnotations:");
        this.indent(1);
        for (int i = 0; i < attr.annotations.length; ++i) {
            this.print(i + ": ");
            this.annotationWriter.write(attr.annotations[i]);
            this.println();
        }
        this.indent(-1);
        return null;
    }

    private void visitParameterAnnotations(String message, RuntimeParameterAnnotations_attribute attr) {
        this.println(message);
        this.indent(1);
        for (int param = 0; param < attr.parameter_annotations.length; ++param) {
            this.println("parameter " + param + ": ");
            this.indent(1);
            for (int i = 0; i < attr.parameter_annotations[param].length; ++i) {
                this.print(i + ": ");
                this.annotationWriter.write(attr.parameter_annotations[param][i]);
                this.println();
            }
            this.indent(-1);
        }
        this.indent(-1);
    }

    @Override
    public Void visitRuntimeVisibleParameterAnnotations(RuntimeVisibleParameterAnnotations_attribute attr, Void ignore) {
        this.visitParameterAnnotations("RuntimeVisibleParameterAnnotations:", attr);
        return null;
    }

    @Override
    public Void visitRuntimeInvisibleParameterAnnotations(RuntimeInvisibleParameterAnnotations_attribute attr, Void ignore) {
        this.visitParameterAnnotations("RuntimeInvisibleParameterAnnotations:", attr);
        return null;
    }

    @Override
    public Void visitPermittedSubclasses(PermittedSubclasses_attribute attr, Void ignore) {
        this.println("PermittedSubclasses:");
        this.indent(1);
        try {
            ConstantPool.CONSTANT_Class_info[] subtypes = attr.getSubtypes(this.constant_pool);
            for (int i = 0; i < subtypes.length; ++i) {
                this.println(this.constantWriter.stringValue(subtypes[i]));
            }
            this.indent(-1);
        }
        catch (ConstantPoolException ex) {
            throw new AssertionError((Object)ex);
        }
        return null;
    }

    @Override
    public Void visitSignature(Signature_attribute attr, Void ignore) {
        this.print("Signature: #" + attr.signature_index);
        this.tab();
        this.println("// " + this.getSignature(attr));
        return null;
    }

    String getSignature(Signature_attribute info) {
        try {
            return info.getSignature(this.constant_pool);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    @Override
    public Void visitSourceDebugExtension(SourceDebugExtension_attribute attr, Void ignore) {
        this.println("SourceDebugExtension:");
        this.indent(1);
        for (String s : attr.getValue().split("[\r\n]+")) {
            this.println(s);
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitSourceFile(SourceFile_attribute attr, Void ignore) {
        this.println("SourceFile: \"" + this.getSourceFile(attr) + "\"");
        return null;
    }

    private String getSourceFile(SourceFile_attribute attr) {
        try {
            return attr.getSourceFile(this.constant_pool);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    @Override
    public Void visitSourceID(SourceID_attribute attr, Void ignore) {
        this.constantWriter.write(attr.sourceID_index);
        return null;
    }

    @Override
    public Void visitStackMap(StackMap_attribute attr, Void ignore) {
        this.println("StackMap: number_of_entries = " + attr.number_of_entries);
        this.indent(1);
        StackMapTableWriter w = new StackMapTableWriter();
        for (StackMap_attribute.stack_map_frame entry : attr.entries) {
            w.write(entry);
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitStackMapTable(StackMapTable_attribute attr, Void ignore) {
        this.println("StackMapTable: number_of_entries = " + attr.number_of_entries);
        this.indent(1);
        StackMapTableWriter w = new StackMapTableWriter();
        for (StackMapTable_attribute.stack_map_frame entry : attr.entries) {
            w.write(entry);
        }
        this.indent(-1);
        return null;
    }

    @Override
    public Void visitSynthetic(Synthetic_attribute attr, Void ignore) {
        this.println("Synthetic: true");
        return null;
    }

    static String getJavaName(String name) {
        return name.replace('/', '.');
    }

    String toHex(byte b, int w) {
        return AttributeWriter.toHex(b & 0xFF, w);
    }

    static String toHex(int i) {
        return StringUtils.toUpperCase(Integer.toString(i, 16));
    }

    static String toHex(int i, int w) {
        String s = StringUtils.toUpperCase(Integer.toHexString(i));
        while (s.length() < w) {
            s = "0" + s;
        }
        return StringUtils.toUpperCase(s);
    }

    static String toHex(byte[] ba) {
        StringBuilder sb = new StringBuilder(ba.length);
        for (byte b : ba) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    class StackMapTableWriter
    implements StackMapTable_attribute.stack_map_frame.Visitor<Void, Void> {
        StackMapTableWriter() {
        }

        public void write(StackMapTable_attribute.stack_map_frame frame) {
            frame.accept(this, null);
        }

        @Override
        public Void visit_same_frame(StackMapTable_attribute.same_frame frame, Void p) {
            this.printHeader(frame, "/* same */");
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame(StackMapTable_attribute.same_locals_1_stack_item_frame frame, Void p) {
            this.printHeader(frame, "/* same_locals_1_stack_item */");
            AttributeWriter.this.indent(1);
            this.printMap("stack", frame.stack);
            AttributeWriter.this.indent(-1);
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame_extended(StackMapTable_attribute.same_locals_1_stack_item_frame_extended frame, Void p) {
            this.printHeader(frame, "/* same_locals_1_stack_item_frame_extended */");
            AttributeWriter.this.indent(1);
            AttributeWriter.this.println("offset_delta = " + frame.offset_delta);
            this.printMap("stack", frame.stack);
            AttributeWriter.this.indent(-1);
            return null;
        }

        @Override
        public Void visit_chop_frame(StackMapTable_attribute.chop_frame frame, Void p) {
            this.printHeader(frame, "/* chop */");
            AttributeWriter.this.indent(1);
            AttributeWriter.this.println("offset_delta = " + frame.offset_delta);
            AttributeWriter.this.indent(-1);
            return null;
        }

        @Override
        public Void visit_same_frame_extended(StackMapTable_attribute.same_frame_extended frame, Void p) {
            this.printHeader(frame, "/* same_frame_extended */");
            AttributeWriter.this.indent(1);
            AttributeWriter.this.println("offset_delta = " + frame.offset_delta);
            AttributeWriter.this.indent(-1);
            return null;
        }

        @Override
        public Void visit_append_frame(StackMapTable_attribute.append_frame frame, Void p) {
            this.printHeader(frame, "/* append */");
            AttributeWriter.this.indent(1);
            AttributeWriter.this.println("offset_delta = " + frame.offset_delta);
            this.printMap("locals", frame.locals);
            AttributeWriter.this.indent(-1);
            return null;
        }

        @Override
        public Void visit_full_frame(StackMapTable_attribute.full_frame frame, Void p) {
            if (frame instanceof StackMap_attribute.stack_map_frame) {
                this.printHeader(frame, "offset = " + frame.offset_delta);
                AttributeWriter.this.indent(1);
            } else {
                this.printHeader(frame, "/* full_frame */");
                AttributeWriter.this.indent(1);
                AttributeWriter.this.println("offset_delta = " + frame.offset_delta);
            }
            this.printMap("locals", frame.locals);
            this.printMap("stack", frame.stack);
            AttributeWriter.this.indent(-1);
            return null;
        }

        void printHeader(StackMapTable_attribute.stack_map_frame frame, String extra) {
            AttributeWriter.this.print("frame_type = " + frame.frame_type + " ");
            AttributeWriter.this.println(extra);
        }

        void printMap(String name, StackMapTable_attribute.verification_type_info[] map) {
            AttributeWriter.this.print(name + " = [");
            for (int i = 0; i < map.length; ++i) {
                StackMapTable_attribute.verification_type_info info = map[i];
                int tag = info.tag;
                switch (tag) {
                    case 7: {
                        AttributeWriter.this.print(" ");
                        AttributeWriter.this.constantWriter.write(((StackMapTable_attribute.Object_variable_info)info).cpool_index);
                        break;
                    }
                    case 8: {
                        AttributeWriter.this.print(" " + this.mapTypeName(tag));
                        AttributeWriter.this.print(" " + ((StackMapTable_attribute.Uninitialized_variable_info)info).offset);
                        break;
                    }
                    default: {
                        AttributeWriter.this.print(" " + this.mapTypeName(tag));
                    }
                }
                AttributeWriter.this.print(i == map.length - 1 ? " " : ",");
            }
            AttributeWriter.this.println("]");
        }

        String mapTypeName(int tag) {
            switch (tag) {
                case 0: {
                    return "top";
                }
                case 1: {
                    return "int";
                }
                case 2: {
                    return "float";
                }
                case 4: {
                    return "long";
                }
                case 3: {
                    return "double";
                }
                case 5: {
                    return "null";
                }
                case 6: {
                    return "this";
                }
                case 7: {
                    return "CP";
                }
                case 8: {
                    return "uninitialized";
                }
            }
            AttributeWriter.this.report("unrecognized verification_type_info tag: " + tag);
            return "[tag:" + tag + "]";
        }
    }
}

