/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.ValueExpression;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.core.api.shared.lang.ClassUtils;

public class UIViewParameter
extends UIInput {
    private static final Logger log = Logger.getLogger(UIViewParameter.class.getName());
    public static final String COMPONENT_FAMILY = "jakarta.faces.ViewParameter";
    public static final String COMPONENT_TYPE = "jakarta.faces.ViewParameter";
    private static final String DELEGATE_FAMILY = "jakarta.faces.Input";
    private static final String DELEGATE_RENDERER_TYPE = "jakarta.faces.Text";
    private static ConcurrentHashMap<ClassLoader, Renderer> delegateRendererMap = new ConcurrentHashMap();

    public UIViewParameter() {
        this.setRendererType(null);
    }

    @Override
    public String getFamily() {
        return "jakarta.faces.ViewParameter";
    }

    @Override
    public void decode(FacesContext context) {
        String value = context.getExternalContext().getRequestParameterMap().get(this.getName());
        if (value != null) {
            this.setSubmittedValue(value);
        }
    }

    @Override
    public void encodeAll(FacesContext context) throws IOException {
        Assert.notNull(context, "context");
        this.setSubmittedValue(this.getStringValue(context));
    }

    public String getName() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.name));
    }

    public String getStringValue(FacesContext context) {
        if (this.getValueExpression("value") != null) {
            return this.getStringValueFromModel(context);
        }
        return (String)this.getLocalValue();
    }

    public String getStringValueFromModel(FacesContext context) throws ConverterException {
        ValueExpression ve = this.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        Object value = ve.getValue(context.getELContext());
        if (value instanceof String) {
            return (String)value;
        }
        Converter converter = this.getConverter();
        if (converter == null) {
            if (value == null) {
                return null;
            }
            converter = context.getApplication().createConverter(value.getClass());
            if (converter == null) {
                return value.toString();
            }
        }
        return converter.getAsString(context, this, value);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public boolean isRendered() {
        return super.isRendered();
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this.getSubmittedValue() == null && this.isRequired()) {
            FacesMessage message;
            String required = this.getRequiredMessage();
            if (required != null) {
                message = new FacesMessage(FacesMessage.SEVERITY_ERROR, required, required);
            } else {
                Object label = MessageUtils.getLabel(context, this);
                message = MessageUtils.getMessage(context, context.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, "jakarta.faces.component.UIInput.REQUIRED", new Object[]{label});
            }
            this.setValid(false);
            context.addMessage(this.getClientId(context), message);
            context.validationFailed();
            context.renderResponse();
            return;
        }
        super.processValidators(context);
    }

    public void setName(String name) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.name), name);
    }

    @Override
    public void updateModel(FacesContext context) {
        super.updateModel(context);
        if (this.getValueExpression("value") == null && this.isValid() && this.isLocalValueSet()) {
            context.getExternalContext().getRequestMap().put(this.getName(), this.getLocalValue());
        }
    }

    @Override
    protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        return UIViewParameter.getDelegateRenderer(context).getConvertedValue(context, this, submittedValue);
    }

    private static Renderer getDelegateRenderer(FacesContext context) {
        ClassLoader classLoader = ClassUtils.getContextClassLoader();
        Renderer delegateRenderer = delegateRendererMap.get(classLoader);
        if (delegateRenderer == null) {
            RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory("jakarta.faces.render.RenderKitFactory");
            RenderKit kit = factory.getRenderKit(context, "HTML_BASIC");
            delegateRenderer = kit.getRenderer(DELEGATE_FAMILY, DELEGATE_RENDERER_TYPE);
            delegateRendererMap.put(classLoader, delegateRenderer);
        }
        return delegateRenderer;
    }

    private static void releaseRenderer() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("releaseRenderer rendererMap -> " + delegateRendererMap.toString());
        }
        ClassLoader classLoader = ClassUtils.getContextClassLoader();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("releaseRenderer classLoader -> " + classLoader.toString());
            log.finest("releaseRenderer renderer -> " + String.valueOf(delegateRendererMap.get(classLoader)));
        }
        delegateRendererMap.remove(classLoader);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("releaseRenderer renderMap -> " + delegateRendererMap.toString());
        }
    }

    @Override
    protected FacesContext getFacesContext() {
        UIComponent parent = this.getParent();
        if (parent != null && parent.isCachedFacesContext()) {
            return parent.getFacesContext();
        }
        return super.getFacesContext();
    }

    static enum PropertyKeys {
        name;

    }

    public static class Reference {
        private int _index;
        private UIViewParameter _param;
        private Object _state;
        private String _viewId;

        public Reference(FacesContext context, UIViewParameter param, int indexInParent, String viewIdAtTimeOfConstruction) {
            this._param = param;
            this._viewId = viewIdAtTimeOfConstruction;
            this._index = indexInParent;
            this._state = param.saveState(context);
        }

        public UIViewParameter getUIViewParameter(FacesContext context) {
            if (context.getViewRoot().getViewId().equals(this._viewId)) {
                return (UIViewParameter)this._param.getParent().getChildren().get(this._index);
            }
            this._param.restoreState(context, this._state);
            return this._param;
        }
    }
}

