/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.filters;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.IoFilter;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.io.DefaultIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.filters.SshIdentHandler;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentFilter
extends IoFilter {
    private static final Logger LOG = LoggerFactory.getLogger(IdentFilter.class);
    private static final String CRLF = "\r\n";
    private DefaultIoWriteFuture received = new DefaultIoWriteFuture((Object)"IdentReceived", null);
    private PropertyResolver properties;
    private SshIdentHandler identHandler;
    private final AtomicReference<InputHandler> readHandler = new AtomicReference();
    private final AtomicReference<OutputHandler> writeHandler = new AtomicReference();
    private final CopyOnWriteArrayList<IdentListener> listeners = new CopyOnWriteArrayList();

    public IdentFilter() {
        this.readHandler.set(new ReadHandler());
        this.writeHandler.set(new WriteHandler());
    }

    public void setIdentHandler(SshIdentHandler handler) {
        this.identHandler = handler;
    }

    public void setPropertyResolver(PropertyResolver resolver) {
        this.properties = resolver;
    }

    @Override
    public InputHandler in() {
        return this.readHandler.get();
    }

    @Override
    public OutputHandler out() {
        return this.writeHandler.get();
    }

    public void addIdentListener(IdentListener listener) {
        this.listeners.addIfAbsent(Objects.requireNonNull(listener));
    }

    public void removeIdentListener(IdentListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private class ReadHandler
    implements InputHandler {
        private final ByteArrayBuffer buffer = new ByteArrayBuffer();
        private boolean haveIdent;

        ReadHandler() {
        }

        @Override
        public synchronized void received(Readable message) throws Exception {
            if (this.haveIdent) {
                IdentFilter.this.owner().passOn(message);
            } else {
                List<String> lines;
                int msgSize = message.available();
                this.buffer.putBuffer(message);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("received({}) in {}, now at {}", new Object[]{IdentFilter.this.properties, msgSize, this.buffer.available()});
                }
                boolean bl = this.haveIdent = !GenericUtils.isEmpty(lines = IdentFilter.this.identHandler.readIdentification((Buffer)this.buffer));
                if (this.haveIdent) {
                    String ident = lines.get(lines.size() - 1);
                    IdentFilter.this.listeners.forEach(listener -> listener.ident(true, ident));
                    IdentFilter.this.received.setValue((Object)Boolean.TRUE);
                    if (this.buffer.available() > 0) {
                        this.buffer.compact();
                        IdentFilter.this.owner().passOn((Readable)this.buffer);
                    }
                    IdentFilter.this.readHandler.set(null);
                }
            }
        }
    }

    private class WriteHandler
    implements OutputHandler {
        private final AtomicBoolean firstMessage = new AtomicBoolean(true);
        private final AtomicReference<IoWriteFuture> lastWrite = new AtomicReference();

        WriteHandler() {
        }

        @Override
        public IoWriteFuture send(int cmd, Buffer message) throws IOException {
            DefaultIoWriteFuture result;
            IoWriteFuture queue;
            boolean isFirst = this.firstMessage.getAndSet(false);
            if (isFirst) {
                IoWriteFuture identSent;
                if (IdentFilter.this.identHandler.isServer() || ((Boolean)CoreModuleProperties.SEND_IMMEDIATE_IDENTIFICATION.getRequired(IdentFilter.this.properties)).booleanValue()) {
                    identSent = IdentFilter.this.owner().send(-1, this.getIdent());
                } else {
                    DefaultIoWriteFuture delayed = new DefaultIoWriteFuture((Object)"DelayedIdent", null);
                    identSent = delayed;
                    IdentFilter.this.received.addListener(identReceived -> {
                        try {
                            IdentFilter.this.owner().send(-1, this.getIdent()).addListener(idSent -> delayed.setValue((Object)(idSent.isWritten() ? Boolean.TRUE : idSent.getException())));
                        }
                        catch (IOException e) {
                            delayed.setValue((Object)e);
                        }
                    });
                }
                this.lastWrite.set(identSent);
                if (message == null) {
                    identSent.addListener(f -> this.lastWrite.compareAndSet(identSent, null));
                    return identSent;
                }
            }
            if ((queue = this.lastWrite.get()) == null || queue.isDone()) {
                this.lastWrite.set(null);
                result = IdentFilter.this.owner().send(cmd, message);
                IdentFilter.this.writeHandler.set(null);
                return result;
            }
            result = new DefaultIoWriteFuture((Object)"Ident", null);
            this.lastWrite.compareAndSet(queue, (IoWriteFuture)result);
            queue.addListener(f -> {
                this.lastWrite.compareAndSet((IoWriteFuture)result, null);
                if (f.isWritten()) {
                    try {
                        IdentFilter.this.owner().send(cmd, message).addListener(msgSent -> result.setValue((Object)(msgSent.isWritten() ? Boolean.TRUE : msgSent.getException())));
                    }
                    catch (IOException e) {
                        LOG.error("sendAfterIdent({}) {}", (Object)IdentFilter.this.properties, (Object)e);
                        result.setValue((Object)e);
                    }
                } else {
                    Throwable t = f.getException();
                    LOG.error("sendAfterIdent({}) {}", (Object)IdentFilter.this.properties, (Object)t);
                    result.setValue((Object)t);
                }
            });
            return result;
        }

        private Buffer getIdent() {
            List<String> ident = IdentFilter.this.identHandler.provideIdentification();
            if (GenericUtils.isEmpty(ident) || !IdentFilter.this.identHandler.isServer() && GenericUtils.size(ident) > 1) {
                throw new IllegalStateException("Invalid SSH protocol version " + ident);
            }
            IdentFilter.this.listeners.forEach(listener -> listener.ident(false, (String)ident.get(ident.size() - 1)));
            String myIdentification = ident.stream().collect(Collectors.joining(IdentFilter.CRLF)) + IdentFilter.CRLF;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getIdent({}) sending ident {}", (Object)IdentFilter.this.properties, (Object)myIdentification);
            }
            return new ByteArrayBuffer(myIdentification.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static interface IdentListener {
        public void ident(boolean var1, String var2);
    }
}

