/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.monitor.MatchingQueries;
import org.apache.lucene.monitor.QueryMatch;

public class MultiMatchingQueries<T extends QueryMatch> {
    private final List<Map<String, T>> matches;
    private final Map<String, Exception> errors;
    private final long queryBuildTime;
    private final long searchTime;
    private final int queriesRun;
    private final int batchSize;

    MultiMatchingQueries(List<Map<String, T>> matches, Map<String, Exception> errors, long queryBuildTime, long searchTime, int queriesRun, int batchSize) {
        this.matches = Collections.unmodifiableList(matches);
        this.errors = Collections.unmodifiableMap(errors);
        this.queryBuildTime = queryBuildTime;
        this.searchTime = searchTime;
        this.queriesRun = queriesRun;
        this.batchSize = batchSize;
    }

    public T matches(String queryId, int docId) {
        Map<String, T> docMatches = this.matches.get(docId);
        if (docMatches == null) {
            return null;
        }
        return (T)((QueryMatch)docMatches.get(queryId));
    }

    public Collection<T> getMatches(int docId) {
        return this.matches.get(docId).values();
    }

    public int getMatchCount(int docId) {
        Map<String, T> docMatches = this.matches.get(docId);
        if (docMatches == null) {
            return 0;
        }
        return docMatches.size();
    }

    public long getQueryBuildTime() {
        return this.queryBuildTime;
    }

    public long getSearchTime() {
        return this.searchTime;
    }

    public int getQueriesRun() {
        return this.queriesRun;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Map<String, Exception> getErrors() {
        return this.errors;
    }

    MatchingQueries<T> singleton() {
        assert (this.matches.size() == 1);
        return new MatchingQueries<T>(this.matches.get(0), this.errors, this.queryBuildTime, this.searchTime, this.queriesRun);
    }
}

