/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc;

import java.util.List;
import java.util.Map;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.protocol.message.RequestProtocol;
import org.apache.linkis.rpc.Receiver;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.method.MessageExecutor;
import org.apache.linkis.rpc.message.method.MethodExecuteWrapper;
import org.apache.linkis.rpc.message.method.ReceiverMethodSearcher;
import org.apache.linkis.rpc.utils.RPCUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0003\u0006\u0001'!)a\u0005\u0001C\u0001O!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003BB\u001a\u0001A\u0003%1\u0006C\u00045\u0001\t\u0007I\u0011B\u001b\t\re\u0002\u0001\u0015!\u00037\u0011\u0015Q\u0004\u0001\"\u0011<\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015A\u0005\u0001\"\u0011M\u0005=iUm]:bO\u0016\u0014VmY3jm\u0016\u0014(BA\u0006\r\u0003\r\u0011\bo\u0019\u0006\u0003\u001b9\ta\u0001\\5oW&\u001c(BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001)iq\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\t!\"\u0003\u0002\u001e\u0015\tA!+Z2fSZ,'\u000f\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005)Q\u000f^5mg*\u00111\u0005D\u0001\u0007G>lWn\u001c8\n\u0005\u0015\u0002#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"a\u0007\u0001\u0002-I,7-Z5wKJlU\r\u001e5pIN+\u0017M]2iKJ,\u0012a\u000b\t\u0003YEj\u0011!\f\u0006\u0003]=\na!\\3uQ>$'B\u0001\u0019\u000b\u0003\u001diWm]:bO\u0016L!AM\u0017\u0003-I+7-Z5wKJlU\r\u001e5pIN+\u0017M]2iKJ\fqC]3dK&4XM]'fi\"|GmU3be\u000eDWM\u001d\u0011\u0002\u001f5,7o]1hK\u0016CXmY;u_J,\u0012A\u000e\t\u0003Y]J!\u0001O\u0017\u0003\u001f5+7o]1hK\u0016CXmY;u_J\f\u0001#\\3tg\u0006<W-\u0012=fGV$xN\u001d\u0011\u0002\u000fI,7-Z5wKR\u0019AhP\"\u0011\u0005Ui\u0014B\u0001 \u0017\u0005\u0011)f.\u001b;\t\u000bA2\u0001\u0019\u0001!\u0011\u0005U\t\u0015B\u0001\"\u0017\u0005\r\te.\u001f\u0005\u0006\t\u001a\u0001\r!R\u0001\u0007g\u0016tG-\u001a:\u0011\u0005m1\u0015BA$\u000b\u0005\u0019\u0019VM\u001c3fe\u0006y!/Z2fSZ,\u0017I\u001c3SKBd\u0017\u0010F\u0002A\u0015.CQ\u0001M\u0004A\u0002\u0001CQ\u0001R\u0004A\u0002\u0015#B\u0001Q'O/\")\u0001\u0007\u0003a\u0001\u0001\")q\n\u0003a\u0001!\u0006AA-\u001e:bi&|g\u000e\u0005\u0002R+6\t!K\u0003\u0002P'*\u0011AKF\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001,S\u0005!!UO]1uS>t\u0007\"\u0002#\t\u0001\u0004)\u0005")
public class MessageReceiver
implements Receiver,
Logging {
    private final ReceiverMethodSearcher receiverMethodSearcher;
    private final MessageExecutor messageExecutor;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        MessageReceiver messageReceiver = this;
        synchronized (messageReceiver) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ReceiverMethodSearcher receiverMethodSearcher() {
        return this.receiverMethodSearcher;
    }

    private MessageExecutor messageExecutor() {
        return this.messageExecutor;
    }

    @Override
    public void receive(Object message, Sender sender) {
        this.logger().info("From caller {} get async message", new Object[]{RPCUtils$.MODULE$.getServiceInstanceFromSender(sender)});
        this.receiveAndReply(message, sender);
    }

    @Override
    public Object receiveAndReply(Object message, Sender sender) {
        this.logger().info("From caller {} get sync message", new Object[]{RPCUtils$.MODULE$.getServiceInstanceFromSender(sender)});
        Object object = message;
        if (object instanceof RequestProtocol) {
            RequestProtocol requestProtocol = (RequestProtocol)object;
            this.logger().info("With message requestProtocol class name:{}", new Object[]{requestProtocol.getClass().getSimpleName()});
            Map<String, List<MethodExecuteWrapper>> methodExecuteWrapper = this.receiverMethodSearcher().getMethodExecuteWrappers(requestProtocol);
            return this.messageExecutor().execute(requestProtocol, methodExecuteWrapper, sender);
        }
        return BoxedUnit.UNIT;
    }

    @Override
    public Object receiveAndReply(Object message, Duration duration, Sender sender) {
        return BoxedUnit.UNIT;
    }

    public MessageReceiver() {
        Logging.$init$((Logging)this);
        this.receiverMethodSearcher = new ReceiverMethodSearcher();
        this.messageExecutor = new MessageExecutor();
    }
}

