/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.restful.api;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.Consts;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.exception.LinkisCommonErrorException;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants;
import org.apache.linkis.governance.common.entity.job.QueryException;
import org.apache.linkis.jobhistory.cache.impl.DefaultQueryCacheManager;
import org.apache.linkis.jobhistory.conf.JobhistoryConfiguration;
import org.apache.linkis.jobhistory.conversions.TaskConversions;
import org.apache.linkis.jobhistory.entity.JobHistory;
import org.apache.linkis.jobhistory.entity.QueryTaskVO;
import org.apache.linkis.jobhistory.service.JobHistoryQueryService;
import org.apache.linkis.jobhistory.transitional.TaskStatus;
import org.apache.linkis.jobhistory.util.JobhistoryUtils;
import org.apache.linkis.jobhistory.util.QueryUtils;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.security.SecurityFilter;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"query api"})
@RestController
@RequestMapping(path={"/jobhistory"})
public class QueryRestfulApi {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Sender sender = Sender.getSender((String)((String)Configuration.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME().getValue()));
    @Autowired
    private JobHistoryQueryService jobHistoryQueryService;
    @Autowired
    private DefaultQueryCacheManager queryCacheManager;

    @ApiOperation(value="governanceStationAdmin", notes="get admin user name", response=Message.class)
    @RequestMapping(path={"/governanceStationAdmin"}, method={RequestMethod.GET})
    public Message governanceStationAdmin(HttpServletRequest req) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"governanceStationAdmin");
        return Message.ok().data("admin", (Object)Configuration.isAdmin((String)username)).data("historyAdmin", (Object)Configuration.isJobHistoryAdmin((String)username)).data("deptAdmin", (Object)Configuration.isDepartmentAdmin((String)username)).data("errorMsgTip", Configuration.ERROR_MSG_TIP().getValue());
    }

    @ApiOperation(value="getTaskByID", notes="get task by id", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="jobId", required=true, dataType="long", example="12345")})
    @RequestMapping(path={"/{id}/get"}, method={RequestMethod.GET})
    public Message getTaskByID(HttpServletRequest req, @PathVariable(value="id") Long jobId) {
        String username = SecurityFilter.getLoginUsername((HttpServletRequest)req);
        if (Configuration.isJobHistoryAdmin((String)username) || !JobhistoryConfiguration.JOB_HISTORY_SAFE_TRIGGER() || Configuration.isDepartmentAdmin((String)username)) {
            username = null;
        }
        JobHistory jobHistory = null;
        if (JobhistoryConfiguration.JOB_HISTORY_QUERY_EXECUTION_CODE_SWITCH()) {
            jobHistory = this.jobHistoryQueryService.getJobHistoryByIdAndNameNoCode(jobId, username);
        } else {
            jobHistory = this.jobHistoryQueryService.getJobHistoryByIdAndName(jobId, username);
            try {
                if (null != jobHistory) {
                    QueryUtils.exchangeExecutionCode(jobHistory);
                }
            }
            catch (Exception e) {
                this.log.error("Exchange executionCode for job with id : {} failed, {}", (Object)jobHistory.getId(), (Object)e);
            }
        }
        QueryTaskVO taskVO = TaskConversions.jobHistory2TaskVO(jobHistory, null);
        if (taskVO == null) {
            return Message.error((String)"The corresponding job was not found, or there may be no permission to view the job(\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684job\uff0c\u4e5f\u53ef\u80fd\u662f\u6ca1\u6709\u67e5\u770b\u8be5job\u7684\u6743\u9650)");
        }
        if (taskVO.getStatus().equals(TaskStatus.Running.toString())) {
            taskVO.setErrCode(null);
            taskVO.setErrDesc(null);
        }
        return Message.ok().data("task", (Object)taskVO);
    }

    @ApiOperation(value="list", notes="list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", dataType="long", example="1658937600001"), @ApiImplicitParam(name="endDate", dataType="long", example="1658937600000"), @ApiImplicitParam(name="status", dataType="String", example=""), @ApiImplicitParam(name="pageNow", required=false, dataType="Integer", value="page now"), @ApiImplicitParam(name="pageSize", dataType="Integer"), @ApiImplicitParam(name="taskID", required=false, dataType="long", value="task id"), @ApiImplicitParam(name="executeApplicationName", dataType="String"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator"), @ApiImplicitParam(name="jobId", required=false, dataType="String", value="job id"), @ApiImplicitParam(name="isAdminView", dataType="Boolean"), @ApiImplicitParam(name="instance", required=false, dataType="String", value="instance")})
    @RequestMapping(path={"/list"}, method={RequestMethod.GET})
    public Message list(HttpServletRequest req, @RequestParam(value="startDate", required=false) Long startDate, @RequestParam(value="endDate", required=false) Long endDate, @RequestParam(value="status", required=false) String status, @RequestParam(value="pageNow", required=false) Integer pageNow, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="taskID", required=false) Long taskID, @RequestParam(value="executeApplicationName", required=false) String executeApplicationName, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="proxyUser", required=false) String proxyUser, @RequestParam(value="isAdminView", required=false) Boolean isAdminView, @RequestParam(value="isDeptView", required=false) Boolean isDeptView, @RequestParam(value="instance", required=false) String instance, @RequestParam(value="engineInstance", required=false) String engineInstance) throws IOException, QueryException {
        List<JobHistory> queryTasks = null;
        try {
            queryTasks = this.getJobhistoryList(req, startDate, endDate, status, pageNow, pageSize, taskID, executeApplicationName, creator, proxyUser, isAdminView, isDeptView, instance, engineInstance);
        }
        catch (Exception e) {
            return Message.error((String)e.getMessage());
        }
        PageInfo pageInfo = new PageInfo(queryTasks);
        List list = pageInfo.getList();
        long total = pageInfo.getTotal();
        ArrayList<QueryTaskVO> vos = new ArrayList<QueryTaskVO>();
        for (JobHistory jobHistory : list) {
            QueryUtils.exchangeExecutionCode(jobHistory);
            QueryTaskVO taskVO = TaskConversions.jobHistory2TaskVO(jobHistory, null);
            vos.add(taskVO);
        }
        return Message.ok().data("tasks", vos).data(JobRequestConstants.TOTAL_PAGE(), (Object)total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="listundonetasks", notes="list undone tasks", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", required=false, dataType="Long", value="start date"), @ApiImplicitParam(name="endDate", required=false, dataType="Long", value="end date"), @ApiImplicitParam(name="status", required=false, dataType="String", value="status"), @ApiImplicitParam(name="pageNow", required=false, dataType="Integer", value="page now"), @ApiImplicitParam(name="pageSize", required=false, dataType="Integer", value="page size"), @ApiImplicitParam(name="startTaskID", required=false, dataType="Long", value="start task id"), @ApiImplicitParam(name="engineType", required=false, dataType="String", value="engine type"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator")})
    @RequestMapping(path={"/listundonetasks"}, method={RequestMethod.GET})
    public Message listundonetasks(HttpServletRequest req, @RequestParam(value="startDate", required=false) Long startDate, @RequestParam(value="endDate", required=false) Long endDate, @RequestParam(value="status", required=false) String status, @RequestParam(value="pageNow", required=false) Integer pageNow, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="startTaskID", required=false) Long taskID, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="creator", required=false) String creator) throws IOException, QueryException {
        String username = SecurityFilter.getLoginUsername((HttpServletRequest)req);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)status)) {
            status = "Running,Inited,Scheduled";
        }
        if (null == pageNow) {
            pageNow = 1;
        }
        if (null == pageSize) {
            pageSize = 20;
        }
        if (endDate == null) {
            endDate = System.currentTimeMillis();
        }
        if (startDate == null) {
            startDate = 0L;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)creator)) {
            creator = null;
        } else if (!QueryUtils.checkNameValid(creator)) {
            return Message.error((String)("Invalid creator : " + creator));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)engineType)) {
            engineType = null;
        } else if (!QueryUtils.checkNameValid(engineType)) {
            return Message.error((String)("Invalid engienType: " + engineType));
        }
        Date sDate = new Date(startDate);
        Date eDate = new Date(endDate);
        if (startDate == 0L) {
            sDate = DateUtils.addDays((Date)eDate, (int)-1);
        }
        if (sDate.getTime() == eDate.getTime()) {
            Calendar instance = Calendar.getInstance();
            instance.setTimeInMillis(endDate);
            instance.add(5, 1);
            eDate = new Date(instance.getTime().getTime());
        }
        List<JobHistory> queryTasks = null;
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            queryTasks = this.jobHistoryQueryService.search(taskID, username, status, creator, sDate, eDate, engineType, this.queryCacheManager.getUndoneTaskMinId(), null, null, null);
        }
        finally {
            PageHelper.clearPage();
        }
        PageInfo pageInfo = new PageInfo(queryTasks);
        List list = pageInfo.getList();
        long total = pageInfo.getTotal();
        ArrayList<QueryTaskVO> vos = new ArrayList<QueryTaskVO>();
        for (JobHistory jobHistory : list) {
            QueryUtils.exchangeExecutionCode(jobHistory);
            QueryTaskVO taskVO = TaskConversions.jobHistory2TaskVO(jobHistory, null);
            vos.add(taskVO);
        }
        return Message.ok().data("tasks", vos).data(JobRequestConstants.TOTAL_PAGE(), (Object)total);
    }

    @ApiOperation(value="listundone", notes="list undone", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", required=false, dataType="Long", value="start date"), @ApiImplicitParam(name="endDate", required=false, dataType="Long", value="end date"), @ApiImplicitParam(name="pageNow", required=false, dataType="Integer", value="page now"), @ApiImplicitParam(name="pageSize", required=false, dataType="Integer", value="page size"), @ApiImplicitParam(name="startTaskID", required=false, dataType="Long", value="startTaskID"), @ApiImplicitParam(name="engineType", required=false, dataType="String", value="engineType"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator")})
    @RequestMapping(path={"/listundone"}, method={RequestMethod.GET})
    public Message listundone(HttpServletRequest req, @RequestParam(value="startDate", required=false) Long startDate, @RequestParam(value="endDate", required=false) Long endDate, @RequestParam(value="pageNow", required=false) Integer pageNow, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="startTaskID", required=false) Long taskID, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="creator", required=false) String creator) throws IOException, QueryException {
        String username = SecurityFilter.getLoginUsername((HttpServletRequest)req);
        if (endDate == null) {
            endDate = System.currentTimeMillis();
        }
        if (startDate == null) {
            startDate = 0L;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)creator)) {
            creator = null;
        } else if (!QueryUtils.checkNameValid(creator)) {
            return Message.error((String)("Invalid creator : " + creator));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)engineType)) {
            engineType = null;
        } else if (!QueryUtils.checkNameValid(engineType)) {
            return Message.error((String)("Invalid engienType: " + engineType));
        }
        Date sDate = new Date(startDate);
        Date eDate = new Date(endDate);
        if (startDate == 0L) {
            sDate = DateUtils.addDays((Date)eDate, (int)-1);
        }
        if (sDate.getTime() == eDate.getTime()) {
            Calendar instance = Calendar.getInstance();
            instance.setTimeInMillis(endDate);
            instance.add(5, 1);
            eDate = new Date(instance.getTime().getTime());
        }
        Integer total = this.jobHistoryQueryService.countUndoneTasks(username, creator, sDate, eDate, engineType, this.queryCacheManager.getUndoneTaskMinId());
        return Message.ok().data(JobRequestConstants.TOTAL_PAGE(), (Object)total);
    }

    @ApiOperation(value="list-taskids", notes="list by task id list", response=Message.class)
    @RequestMapping(path={"/list-taskids"}, method={RequestMethod.GET})
    public Message listTaskIds(HttpServletRequest req, @RequestParam(value="taskID", required=false) String taskids) {
        String username = SecurityFilter.getLoginUsername((HttpServletRequest)req);
        if (Configuration.isAdmin((String)username) || Configuration.isJobHistoryAdmin((String)username)) {
            username = null;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)taskids)) {
            return Message.error((String)"Invalid taskID cannot be empty");
        }
        Matcher matcher = Pattern.compile("^[0-9,]*$").matcher(taskids);
        if (!matcher.matches()) {
            return Message.error((String)"TaskID contains illegal characters");
        }
        List<String> taskidList = Arrays.stream(taskids.split(",")).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(taskidList) && taskidList.size() > (Integer)JobhistoryConfiguration.JOB_HISTORY_QUERY_LIMIT().getValue()) {
            return Message.error((String)"TaskID size cannot exceed 30");
        }
        List<JobHistory> jobHistories = this.jobHistoryQueryService.searchByTasks(taskidList, username);
        ArrayList<QueryTaskVO> vos = new ArrayList<QueryTaskVO>();
        for (JobHistory jobHistory : jobHistories) {
            QueryUtils.exchangeExecutionCode(jobHistory);
            QueryTaskVO taskVO = TaskConversions.jobHistory2TaskVO(jobHistory, null);
            vos.add(taskVO);
        }
        return Message.ok().data(JobRequestConstants.JOB_HISTORY_LIST(), vos);
    }

    @ApiOperation(value="job-extra-info", notes="job extra info:metrix info ,job runtime", response=Message.class)
    @RequestMapping(path={"/job-extra-info"}, method={RequestMethod.GET})
    public Message jobeExtraInfo(HttpServletRequest req, @RequestParam(value="jobId", required=false) Long jobId) {
        String username = SecurityFilter.getLoginUsername((HttpServletRequest)req);
        if (null == jobId) {
            return Message.error((String)"Invalid jobId cannot be empty");
        }
        JobHistory jobHistory = null;
        if (Configuration.isJobHistoryAdmin((String)username) || Configuration.isAdmin((String)username)) {
            username = null;
            jobHistory = this.jobHistoryQueryService.getJobHistoryByIdAndName(jobId, username);
        } else if (Configuration.isDepartmentAdmin((String)username)) {
            List<JobHistory> list;
            String departmentId = JobhistoryUtils.getDepartmentByuser(username);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)departmentId) && !CollectionUtils.isEmpty(list = this.jobHistoryQueryService.search(jobId, null, null, null, null, null, null, null, null, departmentId, null))) {
                jobHistory = list.get(0);
            }
        } else {
            jobHistory = this.jobHistoryQueryService.getJobHistoryByIdAndName(jobId, username);
        }
        if (jobHistory == null) {
            return Message.error((String)"The corresponding job was not found, or there may be no permission to view the job(\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684job\uff0c\u4e5f\u53ef\u80fd\u662f\u6ca1\u6709\u67e5\u770b\u8be5job\u7684\u6743\u9650)");
        }
        try {
            QueryUtils.exchangeExecutionCode(jobHistory);
        }
        catch (Exception e) {
            this.log.error("Exchange executionCode for job with id : {} failed, {}", (Object)jobHistory.getId(), (Object)e);
        }
        Map metricsMap = (Map)BDPJettyServerHelper.gson().fromJson(jobHistory.getMetrics(), Map.class);
        metricsMap.put("executionCode", jobHistory.getExecutionCode());
        metricsMap.put("runtime", TaskConversions.getJobRuntime(metricsMap));
        return Message.ok().data("metricsMap", (Object)metricsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="download job list", notes="download job history list", response=Message.class)
    @RequestMapping(path={"/download-job-list"}, method={RequestMethod.GET})
    public void downloadJobList(HttpServletRequest req, HttpServletResponse response, @RequestParam(value="startDate", required=false) Long startDate, @RequestParam(value="endDate", required=false) Long endDate, @RequestParam(value="status", required=false) String status, @RequestParam(value="pageNow", required=false) Integer pageNow, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="taskID", required=false) Long taskID, @RequestParam(value="executeApplicationName", required=false) String executeApplicationName, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="proxyUser", required=false) String proxyUser, @RequestParam(value="isAdminView", required=false) Boolean isAdminView, @RequestParam(value="isDeptView", required=false) Boolean isDeptView, @RequestParam(value="instance", required=false) String instance, @RequestParam(value="engineInstance", required=false) String engineInstance) throws IOException, QueryException {
        block8: {
            ServletOutputStream outputStream;
            block7: {
                String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"downloadEngineLog");
                String language = req.getHeader("Content-Language");
                outputStream = null;
                try {
                    List<JobHistory> queryTasks = this.getJobhistoryList(req, startDate, endDate, status, pageNow, 5000, taskID, executeApplicationName, creator, proxyUser, isAdminView, isDeptView, instance, engineInstance);
                    PageInfo pageInfo = new PageInfo(queryTasks);
                    if (pageInfo.getTotal() > 5000L) {
                        queryTasks.addAll(this.getJobhistoryList(req, startDate, endDate, status, 2, 5000, taskID, executeApplicationName, creator, proxyUser, isAdminView, isDeptView, instance, engineInstance));
                    }
                    List<QueryTaskVO> vos = pageInfo.getList().stream().peek(jobHistory -> QueryUtils.exchangeExecutionCode(jobHistory)).map(jobHistory -> TaskConversions.jobHistory2TaskVO(jobHistory, null)).collect(Collectors.toList());
                    byte[] bytes = JobhistoryUtils.downLoadJobToExcel(vos, language, isAdminView, isDeptView, pageInfo.getTotal());
                    response.setCharacterEncoding(Consts.UTF_8.toString());
                    response.addHeader("Content-Type", "application/json;charset=UTF-8");
                    response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                    response.addHeader("Content-Disposition", "attachment;filename=" + userName + "_" + startDate + "_history.xlsx");
                    response.addHeader("Content-Length", bytes.length + "");
                    outputStream = response.getOutputStream();
                    outputStream.write(bytes);
                    if (outputStream == null) break block7;
                }
                catch (Exception e) {
                    response.reset();
                    this.log.warn("Download Job History Failed Msg :", (Throwable)e);
                    break block8;
                }
                finally {
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                    IOUtils.closeQuietly(outputStream);
                }
                outputStream.flush();
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="listDurationTop", notes="listDurationTop", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="startDate", dataType="long", example="1658937600001"), @ApiImplicitParam(name="endDate", dataType="long", example="1658937600000"), @ApiImplicitParam(name="executeApplicationName", dataType="String"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator"), @ApiImplicitParam(name="proxyUser", required=false, dataType="String", value="proxyUser"), @ApiImplicitParam(name="pageNow", required=false, dataType="Integer", value="page now"), @ApiImplicitParam(name="pageSize", dataType="Integer")})
    @RequestMapping(path={"/listDurationTop"}, method={RequestMethod.GET})
    public Message listDurationTop(HttpServletRequest req, @RequestParam(value="startDate", required=false) Long startDate, @RequestParam(value="endDate", required=false) Long endDate, @RequestParam(value="executeApplicationName", required=false) String executeApplicationName, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="proxyUser", required=false) String proxyUser, @RequestParam(value="pageNow", required=false) Integer pageNow, @RequestParam(value="pageSize", required=false) Integer pageSize) throws QueryException {
        if (StringUtils.isEmpty((Object)pageNow)) {
            pageNow = 1;
        }
        if (StringUtils.isEmpty((Object)pageSize)) {
            pageSize = 20;
        }
        if (StringUtils.isEmpty((Object)proxyUser)) {
            proxyUser = null;
        } else if (!QueryUtils.checkNameValid(proxyUser)) {
            return Message.error((String)("Invalid proxyUser : " + proxyUser));
        }
        if (StringUtils.isEmpty((Object)creator)) {
            creator = null;
        } else if (!QueryUtils.checkNameValid(creator)) {
            return Message.error((String)("Invalid creator : " + creator));
        }
        if (!StringUtils.isEmpty((Object)executeApplicationName)) {
            if (!QueryUtils.checkNameValid(executeApplicationName)) {
                return Message.error((String)("Invalid applicationName : " + executeApplicationName));
            }
        } else {
            executeApplicationName = null;
        }
        if (endDate == null) {
            endDate = System.currentTimeMillis();
        }
        if (startDate == null) {
            startDate = 0L;
        }
        Date sDate = new Date(startDate);
        Date eDate = new Date(endDate);
        if (sDate.getTime() == eDate.getTime()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(endDate);
            calendar.add(5, 1);
            eDate = new Date(calendar.getTime().getTime());
        }
        List<JobHistory> queryTasks = null;
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            queryTasks = this.jobHistoryQueryService.taskDurationTopN(sDate, eDate, proxyUser, creator, executeApplicationName);
        }
        finally {
            PageHelper.clearPage();
        }
        ArrayList<QueryTaskVO> vos = new ArrayList<QueryTaskVO>();
        for (JobHistory jobHistory : queryTasks) {
            QueryUtils.exchangeExecutionCode(jobHistory);
            QueryTaskVO taskVO = TaskConversions.jobHistory2TaskVO(jobHistory, null);
            vos.add(taskVO);
        }
        return Message.ok().data("tasks", vos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JobHistory> getJobhistoryList(HttpServletRequest req, Long startDate, Long endDate, String status, Integer pageNow, Integer pageSize, Long taskID, String executeApplicationName, String creator, String proxyUser, Boolean isAdminView, Boolean isDeptView, String instance, String engineInstance) throws LinkisCommonErrorException {
        String username = SecurityFilter.getLoginUsername((HttpServletRequest)req);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)status)) {
            status = null;
        }
        if (null == pageNow) {
            pageNow = 1;
        }
        if (null == pageSize) {
            pageSize = 20;
        }
        if (null == endDate) {
            endDate = System.currentTimeMillis();
        }
        if (null == startDate) {
            startDate = 0L;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)creator)) {
            creator = null;
        } else if (!QueryUtils.checkNameValid(creator)) {
            throw new LinkisCommonErrorException(21304, "Invalid creator : " + creator);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)executeApplicationName)) {
            if (!QueryUtils.checkNameValid(executeApplicationName)) {
                throw new LinkisCommonErrorException(21304, "Invalid applicationName : " + executeApplicationName);
            }
        } else {
            executeApplicationName = null;
        }
        Date sDate = new Date(startDate);
        Date eDate = new Date(endDate);
        if (sDate.getTime() == eDate.getTime()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(endDate);
            calendar.add(5, 1);
            eDate = new Date(calendar.getTime().getTime());
        }
        if (isAdminView == null) {
            isAdminView = false;
        }
        String departmentId = null;
        if (Configuration.isJobHistoryAdmin((String)username) & isAdminView) {
            username = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)proxyUser) ? proxyUser : null;
        } else if (null != isDeptView && isDeptView.booleanValue()) {
            departmentId = JobhistoryUtils.getDepartmentByuser(username);
            username = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)departmentId) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)proxyUser) ? proxyUser : null;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)instance)) {
            instance = null;
        } else if (!QueryUtils.checkInstanceNameValid(instance)) {
            throw new LinkisCommonErrorException(21304, "Invalid instances : " + instance);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)engineInstance)) {
            engineInstance = null;
        } else if (!QueryUtils.checkInstanceNameValid(engineInstance)) {
            throw new LinkisCommonErrorException(21304, "Invalid instances : " + engineInstance);
        }
        ArrayList<JobHistory> queryTasks = new ArrayList();
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            queryTasks = this.jobHistoryQueryService.search(taskID, username, status, creator, sDate, eDate, executeApplicationName, null, instance, departmentId, engineInstance);
        }
        finally {
            PageHelper.clearPage();
        }
        return queryTasks;
    }
}

