/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;

public class FieldDesc
implements Writable {
    private String name;
    private TypeInfo typeInfo;

    public FieldDesc() {
    }

    public FieldDesc(String name, TypeInfo typeInfo) {
        this.name = name;
        this.typeInfo = typeInfo;
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public String toString() {
        return this.getName() + ":" + this.getTypeInfo().toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.typeInfo.toString());
    }

    public void readFields(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(in.readUTF());
    }
}

