/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.impl.zk;

import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

@VisibleForTesting
public class ZKPathDumper {
    public static final int INDENT = 2;
    private final CuratorFramework curator;
    private final String root;
    private final boolean verbose;

    public ZKPathDumper(CuratorFramework curator, String root, boolean verbose) {
        Preconditions.checkArgument((curator != null ? 1 : 0) != 0);
        Preconditions.checkArgument((root != null ? 1 : 0) != 0);
        this.curator = curator;
        this.root = root;
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ZK tree for ").append(this.root).append('\n');
        this.expand(builder, this.root, 1);
        return builder.toString();
    }

    private void expand(StringBuilder builder, String path, int indent) {
        try {
            GetChildrenBuilder childrenBuilder = this.curator.getChildren();
            List children = (List)childrenBuilder.forPath(path);
            for (String child : children) {
                String childPath = path + "/" + child;
                Stat stat = (Stat)this.curator.checkExists().forPath(childPath);
                StringBuilder bodyBuilder = new StringBuilder(256);
                bodyBuilder.append("  [").append(stat.getDataLength()).append("]");
                if (stat.getEphemeralOwner() > 0L) {
                    bodyBuilder.append("*");
                }
                if (this.verbose) {
                    builder.append(" -- ");
                    List acls = (List)this.curator.getACL().forPath(childPath);
                    for (ACL acl : acls) {
                        builder.append(RegistrySecurity.aclToString(acl));
                        builder.append(" ");
                    }
                }
                String body = bodyBuilder.toString();
                this.append(builder, indent, ' ');
                builder.append('/').append(child);
                builder.append(body);
                builder.append('\n');
                this.expand(builder, childPath, indent + 2);
            }
        }
        catch (Exception e) {
            builder.append(e.toString()).append("\n");
        }
    }

    private void append(StringBuilder builder, int indent, char c) {
        for (int i = 0; i < indent; ++i) {
            builder.append(c);
        }
    }
}

