/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.service.DefaultSearchService;
import org.apache.linkis.cs.client.service.ResourceService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.resource.BMLResource;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSResourceService
implements ResourceService {
    private static final Logger logger = LoggerFactory.getLogger(CSResourceService.class);
    private static CSResourceService csResourceService;

    private CSResourceService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CSResourceService getInstance() {
        if (null != csResourceService) return csResourceService;
        Class<CSResourceService> clazz = CSResourceService.class;
        synchronized (CSResourceService.class) {
            if (null != csResourceService) return csResourceService;
            csResourceService = new CSResourceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return csResourceService;
        }
    }

    @Override
    public Map<ContextKey, BMLResource> getAllUpstreamBMLResource(String contextIDStr, String nodeName) throws CSErrorException {
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)nodeName)) {
            logger.warn("contextIDStr or nodeName cannot null");
            return null;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            return DefaultSearchService.getInstance().searchUpstreamContextMap(contextID, nodeName, Integer.MAX_VALUE, BMLResource.class);
        }
        catch (ErrorException e) {
            logger.error("Deserialize contextid error. contextID : " + contextIDStr + ", e ", (Throwable)e);
            throw new CSErrorException(70112, "Deserialize contextid error. contextID : " + contextIDStr + ", e " + e.getDesc());
        }
    }

    @Override
    public List<BMLResource> getUpstreamBMLResource(String contextIDStr, String nodeName) throws CSErrorException {
        List<BMLResource> rsList = new ArrayList<BMLResource>();
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)nodeName)) {
            logger.warn("contextIDStr or nodeName cannot null");
            return rsList;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            if (null != contextID) {
                rsList = DefaultSearchService.getInstance().searchUpstreamContext(contextID, nodeName, Integer.MAX_VALUE, BMLResource.class);
            }
            return rsList;
        }
        catch (ErrorException e) {
            logger.error("Failed to get Resource: " + e.getMessage());
            throw new CSErrorException(70112, "Deserialize contextID error. contextIDStr : ", (Throwable)e);
        }
    }
}

