/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import springfox.documentation.schema.Example;
import springfox.documentation.service.Header;
import springfox.documentation.service.Representation;
import springfox.documentation.service.VendorExtension;

public class Response {
    private final String code;
    private final String description;
    private final boolean isDefault;
    private final Set<Representation> representations = new HashSet<Representation>();
    private final List<Header> headers = new ArrayList<Header>();
    private final List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();
    private final List<Example> examples = new ArrayList<Example>();

    public Response(String code, String description, boolean isDefault, Collection<Header> headers, Collection<Representation> representations, Collection<Example> examples, Collection<VendorExtension> vendorExtensions) {
        this.code = code;
        this.description = description;
        this.isDefault = isDefault;
        this.representations.addAll(representations);
        this.headers.addAll(headers);
        this.vendorExtensions.addAll(vendorExtensions);
        this.examples.addAll(examples);
    }

    public SortedSet<Representation> getRepresentations() {
        return this.representations.stream().collect(Collectors.toCollection(() -> new TreeSet<Representation>(Comparator.comparing(Representation::getMediaType))));
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<VendorExtension> getVendorExtensions() {
        return this.vendorExtensions;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Example> getExamples() {
        return this.examples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return Objects.equals(this.code, response.code);
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public String toString() {
        return "Response{code='" + this.code + '\'' + ", description='" + this.description + '\'' + ", isDefault=" + this.isDefault + ", representations=" + this.representations + ", headers=" + this.headers + ", vendorExtensions=" + this.vendorExtensions + ", examples=" + this.examples + '}';
    }
}

