/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.context;

import javax.annotation.PostConstruct;
import org.apache.linkis.entrance.EntranceContext;
import org.apache.linkis.entrance.EntranceParser;
import org.apache.linkis.entrance.event.EntranceEvent;
import org.apache.linkis.entrance.event.EntranceEventListener;
import org.apache.linkis.entrance.event.EntranceEventListenerBus;
import org.apache.linkis.entrance.interceptor.EntranceInterceptor;
import org.apache.linkis.entrance.log.LogManager;
import org.apache.linkis.entrance.persistence.PersistenceManager;
import org.apache.linkis.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="entranceContext")
public class DefaultEntranceContext
extends EntranceContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEntranceContext.class);
    @Autowired
    private EntranceParser entranceParser;
    @Autowired
    private PersistenceManager persistenceManager;
    @Autowired
    private LogManager logManager;
    @Autowired
    private Scheduler scheduler;
    @Autowired
    @Qualifier(value="entranceInterceptors")
    private EntranceInterceptor[] entranceInterceptors;
    @Autowired
    private EntranceEventListenerBus<EntranceEventListener, EntranceEvent> listenerBus;

    public DefaultEntranceContext(EntranceParser entranceParser, PersistenceManager persistenceManager, LogManager logManager, Scheduler scheduler, EntranceInterceptor[] entranceInterceptors, EntranceEventListenerBus<EntranceEventListener, EntranceEvent> listenerBus) {
        this.entranceParser = entranceParser;
        this.persistenceManager = persistenceManager;
        this.logManager = logManager;
        this.scheduler = scheduler;
        this.entranceInterceptors = entranceInterceptors;
        this.listenerBus = listenerBus;
    }

    public DefaultEntranceContext() {
    }

    @PostConstruct
    public void init() {
        this.entranceParser.setEntranceContext(this);
        logger.info("Finished init entranceParser from postConstruct end!");
        this.persistenceManager.setEntranceContext(this);
        this.logManager.setEntranceContext(this);
    }

    @Override
    public Scheduler getOrCreateScheduler() {
        return this.scheduler;
    }

    @Override
    public EntranceParser getOrCreateEntranceParser() {
        return this.entranceParser;
    }

    @Override
    public EntranceInterceptor[] getOrCreateEntranceInterceptors() {
        return this.entranceInterceptors;
    }

    @Override
    public LogManager getOrCreateLogManager() {
        return this.logManager;
    }

    @Override
    public PersistenceManager getOrCreatePersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public EntranceEventListenerBus<EntranceEventListener, EntranceEvent> getOrCreateEventListenerBus() {
        return this.listenerBus;
    }
}

