/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.util.Locale;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;

public final class KerberosUtils {
    private static final String HOSTNAME_PATTERN = "_HOST";
    private static final float TICKET_RENEW_WINDOW = 0.8f;

    public static String[] splitPrincipal(String principal) {
        return principal.split("[/@]");
    }

    public static String canonicalPrincipal(String principal, String hostname) {
        String[] names = KerberosUtils.splitPrincipal(principal);
        if (names.length != 3) {
            throw new IllegalArgumentException("Kerberos principal should have 3 parts: " + principal);
        }
        if (!names[1].equals(HOSTNAME_PATTERN)) {
            return principal;
        }
        return String.format("%s/%s@%s", names[0], hostname.toLowerCase(Locale.ENGLISH), names[2]);
    }

    public static String canonicalClientPrincipal(String principal, String hostname) {
        String[] components = KerberosUtils.splitPrincipal(principal);
        if (components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principal;
        }
        return KerberosUtils.canonicalPrincipal(principal, hostname);
    }

    public static KerberosTicket getTgt(Subject subject) {
        Set<KerberosTicket> tickets = subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!KerberosUtils.isOriginalTgt(ticket)) continue;
            return ticket;
        }
        throw new IllegalArgumentException("kerberos ticket not found in " + subject);
    }

    public static long getTgtRefreshTime(KerberosTicket ticket) {
        long start = ticket.getStartTime().getTime();
        long end = ticket.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    public static boolean isOriginalTgt(KerberosTicket ticket) {
        return KerberosUtils.isTgsPrincipal(ticket.getServer());
    }

    private static boolean isTgsPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        return principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm());
    }
}

