/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms.pool;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.messaginghub.pooled.jms.JmsPoolSession;
import org.messaginghub.pooled.jms.JmsPoolSessionEventListener;
import org.messaginghub.pooled.jms.pool.PooledSessionHolder;
import org.messaginghub.pooled.jms.pool.PooledSessionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnection
implements ExceptionListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnection.class);
    protected Connection connection;
    private int referenceCount;
    private long lastUsed = System.currentTimeMillis();
    private boolean hasExpired;
    private int idleTimeout = 30000;
    private boolean useAnonymousProducers = true;
    private int explicitProducerCacheSize = 0;
    private int jmsMajorVersion = 1;
    private int jmsMinorVersion = 1;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final GenericKeyedObjectPool<PooledSessionKey, PooledSessionHolder> sessionPool;
    private final List<JmsPoolSession> loanedSessions = new CopyOnWriteArrayList<JmsPoolSession>();
    private ExceptionListener parentExceptionListener;

    public PooledConnection(Connection connection) {
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setJmxEnabled(false);
        poolConfig.setTestOnBorrow(true);
        this.connection = this.wrap(connection);
        try {
            this.setParentExceptionListener(connection.getExceptionListener());
            this.connection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException ex) {
            LOG.warn("Could not set exception listener on create of ConnectionPool");
        }
        try {
            Connection.class.getMethod("createSession", Integer.TYPE);
            try {
                this.jmsMajorVersion = connection.getMetaData().getJMSMajorVersion();
                this.jmsMinorVersion = connection.getMetaData().getJMSMajorVersion();
            }
            catch (JMSException ex) {
                LOG.debug("Error while fetching JMS API version from provider, defaulting to v1.1");
                this.jmsMajorVersion = 1;
                this.jmsMinorVersion = 1;
            }
        }
        catch (NoSuchMethodException nsme) {
            LOG.trace("JMS API on the classpath is not JMS 2.0+ defaulting to v1.1 internally");
        }
        this.sessionPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new KeyedPooledObjectFactory<PooledSessionKey, PooledSessionHolder>(){

            public PooledObject<PooledSessionHolder> makeObject(PooledSessionKey sessionKey) throws Exception {
                return new DefaultPooledObject((Object)new PooledSessionHolder(PooledConnection.this, PooledConnection.this.makeSession(sessionKey), PooledConnection.this.useAnonymousProducers, PooledConnection.this.explicitProducerCacheSize));
            }

            public void destroyObject(PooledSessionKey sessionKey, PooledObject<PooledSessionHolder> pooledObject) throws Exception {
                ((PooledSessionHolder)pooledObject.getObject()).close();
            }

            public boolean validateObject(PooledSessionKey sessionKey, PooledObject<PooledSessionHolder> pooledObject) {
                PooledSessionHolder sessionHolder = (PooledSessionHolder)pooledObject.getObject();
                try {
                    sessionHolder.getSession().getTransacted();
                }
                catch (IllegalStateException jmsISE) {
                    return false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }

            public void activateObject(PooledSessionKey sessionKey, PooledObject<PooledSessionHolder> pooledObject) throws Exception {
            }

            public void passivateObject(PooledSessionKey sessionKey, PooledObject<PooledSessionHolder> pooledObject) throws Exception {
            }
        }, poolConfig);
    }

    public void setHasExpired(boolean val) {
        this.hasExpired = val;
    }

    protected Session makeSession(PooledSessionKey key) throws JMSException {
        return this.connection.createSession(key.isTransacted(), key.getAckMode());
    }

    protected Connection wrap(Connection connection) {
        return connection;
    }

    protected void unWrap(Connection connection) {
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.connection.start();
            }
            catch (Throwable error) {
                this.started.set(false);
                this.close();
                throw error;
            }
        }
    }

    public synchronized Connection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        JmsPoolSession session;
        PooledSessionKey key = new PooledSessionKey(transacted, ackMode);
        try {
            session = new JmsPoolSession(key, (PooledSessionHolder)this.sessionPool.borrowObject((Object)key), (KeyedObjectPool<PooledSessionKey, PooledSessionHolder>)this.sessionPool, key.isTransacted());
            session.addSessionEventListener(new JmsPoolSessionEventListener(){

                @Override
                public void onTemporaryTopicCreate(TemporaryTopic tempTopic) {
                }

                @Override
                public void onTemporaryQueueCreate(TemporaryQueue tempQueue) {
                }

                @Override
                public void onSessionClosed(JmsPoolSession session) {
                    PooledConnection.this.loanedSessions.remove(session);
                }
            });
            this.loanedSessions.add(session);
        }
        catch (Exception e) {
            IllegalStateException illegalStateException = new IllegalStateException(e.toString());
            illegalStateException.initCause((Throwable)e);
            throw illegalStateException;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() {
        if (this.connection == null) return;
        try {
            this.sessionPool.close();
        }
        catch (Exception exception) {
            try {
                this.connection.close();
                return;
            }
            catch (Exception exception2) {
                return;
            }
            finally {
                this.connection = null;
            }
        }
        catch (Throwable throwable) {
            try {
                this.connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
            finally {
                this.connection = null;
            }
        }
        try {
            this.connection.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            this.connection = null;
        }
    }

    public boolean isClosed() {
        return this.connection == null;
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
        if (this.referenceCount == 0) {
            for (JmsPoolSession session : this.loanedSessions) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
            this.loanedSessions.clear();
            this.unWrap(this.getConnection());
            this.idleTimeoutCheck();
        }
    }

    public synchronized boolean idleTimeoutCheck() {
        boolean expired = false;
        if (this.connection == null) {
            return true;
        }
        if (this.hasExpired && this.referenceCount == 0) {
            this.close();
            expired = true;
        }
        if (this.referenceCount == 0 && this.idleTimeout > 0 && this.lastUsed + (long)this.idleTimeout - System.currentTimeMillis() < 0L) {
            this.hasExpired = true;
            this.close();
            expired = true;
        }
        return expired;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getMaxSessionsPerConnection() {
        return this.sessionPool.getMaxTotalPerKey();
    }

    public void setMaxSessionsPerConnection(int maActiveSessionsPerConnection) {
        this.sessionPool.setMaxTotalPerKey(maActiveSessionsPerConnection);
    }

    public boolean isUseAnonymousProducers() {
        return this.useAnonymousProducers;
    }

    public void setUseAnonymousProducers(boolean value) {
        this.useAnonymousProducers = value;
    }

    public int getExplicitProducerCacheSize() {
        return this.explicitProducerCacheSize;
    }

    public void setExplicitProducerCacheSize(int cacheSize) {
        this.explicitProducerCacheSize = cacheSize;
    }

    public int getNumSessions() {
        return this.sessionPool.getNumIdle() + this.sessionPool.getNumActive();
    }

    public int getNumIdleSessions() {
        return this.sessionPool.getNumIdle();
    }

    public int getNumActiveSessions() {
        return this.sessionPool.getNumActive();
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.sessionPool.setBlockWhenExhausted(block);
    }

    public boolean isBlockIfSessionPoolIsFull() {
        return this.sessionPool.getBlockWhenExhausted();
    }

    public long getBlockIfSessionPoolIsFullTimeout() {
        return this.sessionPool.getMaxWaitMillis();
    }

    public void setBlockIfSessionPoolIsFullTimeout(long blockIfSessionPoolIsFullTimeout) {
        this.sessionPool.setMaxWaitMillis(blockIfSessionPoolIsFullTimeout);
    }

    public boolean isJMSVersionSupported(int requiredMajor, int requiredMinor) {
        return this.jmsMajorVersion >= requiredMajor && this.jmsMinorVersion >= requiredMinor;
    }

    public ExceptionListener getParentExceptionListener() {
        return this.parentExceptionListener;
    }

    public void setParentExceptionListener(ExceptionListener parentExceptionListener) {
        this.parentExceptionListener = parentExceptionListener;
    }

    public void onException(JMSException exception) {
        this.close();
        if (this.parentExceptionListener != null) {
            this.parentExceptionListener.onException(exception);
        }
    }

    public String toString() {
        return "ConnectionPool[" + this.connection + "]";
    }

    public void checkClientJMSVersionSupport(int requiredMajor, int requiredMinor) throws JMSException {
        this.checkClientJMSVersionSupport(requiredMajor, requiredMinor, false);
    }

    public void checkClientJMSVersionSupport(int requiredMajor, int requiredMinor, boolean runtimeEx) throws JMSException {
        if (this.jmsMajorVersion >= requiredMajor && this.jmsMinorVersion >= requiredMinor) {
            return;
        }
        String message = "JMS v" + requiredMajor + "." + requiredMinor + " client feature requested, configured client supports JMS v" + this.jmsMajorVersion + "." + this.jmsMinorVersion;
        if (runtimeEx) {
            throw new JMSRuntimeException(message);
        }
        throw new JMSException(message);
    }
}

