/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.pending.jdk;

import org.apache.sis.util.resources.Errors;

public final class HexFormat {
    private static final HexFormat INSTANCE = new HexFormat();

    private HexFormat() {
    }

    public static HexFormat of() {
        return INSTANCE;
    }

    public byte[] parseHex(CharSequence string) {
        int length = string.length();
        if ((length & 1) != 0) {
            throw new IllegalArgumentException(Errors.format((short)118, "wkb"));
        }
        byte[] data = new byte[length >>> 1];
        int i = 0;
        while (i < length) {
            data[i >>> 1] = (byte)(HexFormat.fromHexDigit(string.charAt(i++)) << 4 | HexFormat.fromHexDigit(string.charAt(i++)));
        }
        return data;
    }

    public static int fromHexDigit(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c - 55;
        }
        if (c >= 97 && c <= 102) {
            return c - 87;
        }
        throw new NumberFormatException(Errors.format((short)180, String.valueOf(c)));
    }
}

