/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.sparql.util.iso.IsoAlgTuple;

public class IsoMatcher {
    public static boolean isomorphic(Graph graph1, Graph graph2) {
        List<Tuple<Node>> x1 = IsoMatcher.tuplesTriples(graph1.find());
        List<Tuple<Node>> x2 = IsoMatcher.tuplesTriples(graph2.find());
        return IsoMatcher.isomorphicTuples(x1, x2, NodeUtils.sameRdfTerm);
    }

    public static boolean isomorphic(DatasetGraph dsg1, DatasetGraph dsg2) {
        List<Tuple<Node>> x1 = IsoMatcher.tuplesQuads(dsg1.find());
        List<Tuple<Node>> x2 = IsoMatcher.tuplesQuads(dsg2.find());
        return IsoMatcher.isomorphicTuples(x1, x2, NodeUtils.sameRdfTerm);
    }

    public static boolean isomorphic(Collection<Triple> triples1, Collection<Triple> triples2) {
        List<Tuple<Node>> x1 = IsoMatcher.tuplesTriples(triples1.iterator());
        List<Tuple<Node>> x2 = IsoMatcher.tuplesTriples(triples2.iterator());
        return IsoMatcher.isomorphicTuples(x1, x2, NodeUtils.sameRdfTerm);
    }

    public static boolean isomorphicTuples(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2) {
        return IsoMatcher.isomorphicTuples(x1, x2, NodeUtils.sameRdfTerm);
    }

    private static List<Tuple<Node>> tuplesQuads(Iterator<Quad> iter) {
        return Iter.iter(iter).map(q -> TupleFactory.tuple(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject())).toList();
    }

    private static List<Tuple<Node>> tuplesTriples(Iterator<Triple> iter) {
        try {
            List<Tuple<Node>> list = Iter.iter(iter).map(t -> TupleFactory.tuple(t.getSubject(), t.getPredicate(), t.getObject())).toList();
            return list;
        }
        finally {
            Iter.close(iter);
        }
    }

    private static boolean isomorphicTuples(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2, EqualityTest nodeTest) {
        return IsoAlgTuple.isIsomorphic(x1, x2, nodeTest);
    }
}

