/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.Envelope;

public class RobustLineIntersector
extends LineIntersector {
    @Override
    public void computeIntersection(Coordinate p, Coordinate p1, Coordinate p2) {
        this.isProper = false;
        if (Envelope.intersects(p1, p2, p) && Orientation.index(p1, p2, p) == 0 && Orientation.index(p2, p1, p) == 0) {
            this.isProper = true;
            if (p.equals(p1) || p.equals(p2)) {
                this.isProper = false;
            }
            this.result = 1;
            return;
        }
        this.result = 0;
    }

    @Override
    protected int computeIntersect(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean collinear;
        this.isProper = false;
        if (!Envelope.intersects(p1, p2, q1, q2)) {
            return 0;
        }
        int Pq1 = Orientation.index(p1, p2, q1);
        int Pq2 = Orientation.index(p1, p2, q2);
        if (Pq1 > 0 && Pq2 > 0 || Pq1 < 0 && Pq2 < 0) {
            return 0;
        }
        int Qp1 = Orientation.index(q1, q2, p1);
        int Qp2 = Orientation.index(q1, q2, p2);
        if (Qp1 > 0 && Qp2 > 0 || Qp1 < 0 && Qp2 < 0) {
            return 0;
        }
        boolean bl = collinear = Pq1 == 0 && Pq2 == 0 && Qp1 == 0 && Qp2 == 0;
        if (collinear) {
            return this.computeCollinearIntersection(p1, p2, q1, q2);
        }
        Coordinate p = null;
        double z = Double.NaN;
        if (Pq1 == 0 || Pq2 == 0 || Qp1 == 0 || Qp2 == 0) {
            this.isProper = false;
            if (p1.equals2D(q1)) {
                p = p1;
                z = RobustLineIntersector.zGet(p1, q1);
            } else if (p1.equals2D(q2)) {
                p = p1;
                z = RobustLineIntersector.zGet(p1, q2);
            } else if (p2.equals2D(q1)) {
                p = p2;
                z = RobustLineIntersector.zGet(p2, q1);
            } else if (p2.equals2D(q2)) {
                p = p2;
                z = RobustLineIntersector.zGet(p2, q2);
            } else if (Pq1 == 0) {
                p = q1;
                z = RobustLineIntersector.zGetOrInterpolate(q1, p1, p2);
            } else if (Pq2 == 0) {
                p = q2;
                z = RobustLineIntersector.zGetOrInterpolate(q2, p1, p2);
            } else if (Qp1 == 0) {
                p = p1;
                z = RobustLineIntersector.zGetOrInterpolate(p1, q1, q2);
            } else if (Qp2 == 0) {
                p = p2;
                z = RobustLineIntersector.zGetOrInterpolate(p2, q1, q2);
            }
        } else {
            this.isProper = true;
            p = this.intersection(p1, p2, q1, q2);
            z = RobustLineIntersector.zInterpolate(p, p1, p2, q1, q2);
        }
        this.intPt[0] = RobustLineIntersector.copyWithZ(p, z);
        return 1;
    }

    private int computeCollinearIntersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean q1inP = Envelope.intersects(p1, p2, q1);
        boolean q2inP = Envelope.intersects(p1, p2, q2);
        boolean p1inQ = Envelope.intersects(q1, q2, p1);
        boolean p2inQ = Envelope.intersects(q1, q2, p2);
        if (q1inP && q2inP) {
            this.intPt[0] = RobustLineIntersector.copyWithZInterpolate(q1, p1, p2);
            this.intPt[1] = RobustLineIntersector.copyWithZInterpolate(q2, p1, p2);
            return 2;
        }
        if (p1inQ && p2inQ) {
            this.intPt[0] = RobustLineIntersector.copyWithZInterpolate(p1, q1, q2);
            this.intPt[1] = RobustLineIntersector.copyWithZInterpolate(p2, q1, q2);
            return 2;
        }
        if (q1inP && p1inQ) {
            this.intPt[0] = RobustLineIntersector.copyWithZInterpolate(q1, p1, p2);
            this.intPt[1] = RobustLineIntersector.copyWithZInterpolate(p1, q1, q2);
            return q1.equals(p1) && !q2inP && !p2inQ ? 1 : 2;
        }
        if (q1inP && p2inQ) {
            this.intPt[0] = RobustLineIntersector.copyWithZInterpolate(q1, p1, p2);
            this.intPt[1] = RobustLineIntersector.copyWithZInterpolate(p2, q1, q2);
            return q1.equals(p2) && !q2inP && !p1inQ ? 1 : 2;
        }
        if (q2inP && p1inQ) {
            this.intPt[0] = RobustLineIntersector.copyWithZInterpolate(q2, p1, p2);
            this.intPt[1] = RobustLineIntersector.copyWithZInterpolate(p1, q1, q2);
            return q2.equals(p1) && !q1inP && !p2inQ ? 1 : 2;
        }
        if (q2inP && p2inQ) {
            this.intPt[0] = RobustLineIntersector.copyWithZInterpolate(q2, p1, p2);
            this.intPt[1] = RobustLineIntersector.copyWithZInterpolate(p2, q1, q2);
            return q2.equals(p2) && !q1inP && !p1inQ ? 1 : 2;
        }
        return 0;
    }

    private static Coordinate copyWithZInterpolate(Coordinate p, Coordinate p1, Coordinate p2) {
        return RobustLineIntersector.copyWithZ(p, RobustLineIntersector.zGetOrInterpolate(p, p1, p2));
    }

    private static Coordinate copyWithZ(Coordinate p, double z) {
        Coordinate pCopy = RobustLineIntersector.copy(p);
        if (!Double.isNaN(z) && Coordinates.hasZ(pCopy)) {
            pCopy.setZ(z);
        }
        return pCopy;
    }

    private static Coordinate copy(Coordinate p) {
        return p.copy();
    }

    private Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = this.intersectionSafe(p1, p2, q1, q2);
        if (!this.isInSegmentEnvelopes(intPt)) {
            intPt = RobustLineIntersector.copy(RobustLineIntersector.nearestEndpoint(p1, p2, q1, q2));
        }
        if (this.precisionModel != null) {
            this.precisionModel.makePrecise(intPt);
        }
        return intPt;
    }

    private Coordinate intersectionSafe(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = Intersection.intersection(p1, p2, q1, q2);
        if (intPt == null) {
            intPt = RobustLineIntersector.nearestEndpoint(p1, p2, q1, q2);
        }
        return intPt;
    }

    private boolean isInSegmentEnvelopes(Coordinate intPt) {
        Envelope env0 = new Envelope(this.inputLines[0][0], this.inputLines[0][1]);
        Envelope env1 = new Envelope(this.inputLines[1][0], this.inputLines[1][1]);
        return env0.contains(intPt) && env1.contains(intPt);
    }

    private static Coordinate nearestEndpoint(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate nearestPt = p1;
        double minDist = Distance.pointToSegment(p1, q1, q2);
        double dist = Distance.pointToSegment(p2, q1, q2);
        if (dist < minDist) {
            minDist = dist;
            nearestPt = p2;
        }
        if ((dist = Distance.pointToSegment(q1, p1, p2)) < minDist) {
            minDist = dist;
            nearestPt = q1;
        }
        if ((dist = Distance.pointToSegment(q2, p1, p2)) < minDist) {
            minDist = dist;
            nearestPt = q2;
        }
        return nearestPt;
    }

    private static double zGet(Coordinate p, Coordinate q) {
        double z = p.getZ();
        if (Double.isNaN(z)) {
            z = q.getZ();
        }
        return z;
    }

    private static double zGetOrInterpolate(Coordinate p, Coordinate p1, Coordinate p2) {
        double z = p.getZ();
        if (!Double.isNaN(z)) {
            return z;
        }
        return RobustLineIntersector.zInterpolate(p, p1, p2);
    }

    private static double zInterpolate(Coordinate p, Coordinate p1, Coordinate p2) {
        double p1z = p1.getZ();
        double p2z = p2.getZ();
        if (Double.isNaN(p1z)) {
            return p2z;
        }
        if (Double.isNaN(p2z)) {
            return p1z;
        }
        if (p.equals2D(p1)) {
            return p1z;
        }
        if (p.equals2D(p2)) {
            return p2z;
        }
        double dz = p2z - p1z;
        if (dz == 0.0) {
            return p1z;
        }
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double seglen = dx * dx + dy * dy;
        double xoff = p.x - p1.x;
        double yoff = p.y - p1.y;
        double plen = xoff * xoff + yoff * yoff;
        double frac = Math.sqrt(plen / seglen);
        double zoff = dz * frac;
        double zInterpolated = p1z + zoff;
        return zInterpolated;
    }

    private static double zInterpolate(Coordinate p, Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        double zp = RobustLineIntersector.zInterpolate(p, p1, p2);
        double zq = RobustLineIntersector.zInterpolate(p, q1, q2);
        if (Double.isNaN(zp)) {
            return zq;
        }
        if (Double.isNaN(zq)) {
            return zp;
        }
        return (zp + zq) / 2.0;
    }
}

