/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by MockGen. DO NOT EDIT.
// Source: datasource_manager.go

// Package mock is a generated GoMock package.
package mock

import (
	context "context"
	sql "database/sql"
	reflect "reflect"
	sync "sync"

	gomock "github.com/golang/mock/gomock"

	datasource "seata.apache.org/seata-go/pkg/datasource/sql/datasource"
	types "seata.apache.org/seata-go/pkg/datasource/sql/types"
	branch "seata.apache.org/seata-go/pkg/protocol/branch"
	rm "seata.apache.org/seata-go/pkg/rm"
)

// MockDataSourceManager is a mock of DataSourceManager interface.
type MockDataSourceManager struct {
	ctrl       *gomock.Controller
	recorder   *MockDataSourceManagerMockRecorder
	branchType branch.BranchType
}

// MockDataSourceManagerMockRecorder is the mock recorder for MockDataSourceManager.
type MockDataSourceManagerMockRecorder struct {
	mock *MockDataSourceManager
}

// NewMockDataSourceManager creates a new mock instance.
func NewMockDataSourceManager(ctrl *gomock.Controller) *MockDataSourceManager {
	mock := &MockDataSourceManager{ctrl: ctrl}
	mock.recorder = &MockDataSourceManagerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockDataSourceManager) EXPECT() *MockDataSourceManagerMockRecorder {
	return m.recorder
}

// BranchCommit mocks base method.
func (m *MockDataSourceManager) BranchCommit(ctx context.Context, resource rm.BranchResource) (branch.BranchStatus, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BranchCommit", ctx, resource)
	ret0, _ := ret[0].(branch.BranchStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BranchCommit indicates an expected call of BranchCommit.
func (mr *MockDataSourceManagerMockRecorder) BranchCommit(ctx, resource interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BranchCommit", reflect.TypeOf((*MockDataSourceManager)(nil).BranchCommit), ctx, resource)
}

// BranchRegister mocks base method.
func (m *MockDataSourceManager) BranchRegister(ctx context.Context, param rm.BranchRegisterParam) (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BranchRegister", ctx, param)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BranchRegister indicates an expected call of BranchRegister.
func (mr *MockDataSourceManagerMockRecorder) BranchRegister(ctx, param interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BranchRegister", reflect.TypeOf((*MockDataSourceManager)(nil).BranchRegister), ctx, param)
}

// BranchReport mocks base method.
func (m *MockDataSourceManager) BranchReport(ctx context.Context, param rm.BranchReportParam) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BranchReport", ctx, param)
	ret0, _ := ret[0].(error)
	return ret0
}

// BranchReport indicates an expected call of BranchReport.
func (mr *MockDataSourceManagerMockRecorder) BranchReport(ctx, param interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BranchReport", reflect.TypeOf((*MockDataSourceManager)(nil).BranchReport), ctx, param)
}

// BranchRollback mocks base method.
func (m *MockDataSourceManager) BranchRollback(ctx context.Context, resource rm.BranchResource) (branch.BranchStatus, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BranchRollback", ctx, resource)
	ret0, _ := ret[0].(branch.BranchStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BranchRollback indicates an expected call of BranchRollback.
func (mr *MockDataSourceManagerMockRecorder) BranchRollback(ctx, resource interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BranchRollback", reflect.TypeOf((*MockDataSourceManager)(nil).BranchRollback), ctx, resource)
}

// CreateTableMetaCache mocks base method.
func (m *MockDataSourceManager) CreateTableMetaCache(ctx context.Context, resID string, dbType types.DBType, db *sql.DB) (datasource.TableMetaCache, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTableMetaCache", ctx, resID, dbType, db)
	ret0, _ := ret[0].(datasource.TableMetaCache)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTableMetaCache indicates an expected call of CreateTableMetaCache.
func (mr *MockDataSourceManagerMockRecorder) CreateTableMetaCache(ctx, resID, dbType, db interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTableMetaCache", reflect.TypeOf((*MockDataSourceManager)(nil).CreateTableMetaCache), ctx, resID, dbType, db)
}

func (m *MockDataSourceManager) SetBranchType(branchType branch.BranchType) {
	m.branchType = branchType
}

// GetBranchType mocks base method.
func (m *MockDataSourceManager) GetBranchType() branch.BranchType {
	return m.branchType
}

// GetBranchType indicates an expected call of GetBranchType.
func (mr *MockDataSourceManagerMockRecorder) GetBranchType() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetBranchType", reflect.TypeOf((*MockDataSourceManager)(nil).GetBranchType))
}

// GetCachedResources mocks base method.
func (m *MockDataSourceManager) GetCachedResources() *sync.Map {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCachedResources")
	ret0, _ := ret[0].(*sync.Map)
	return ret0
}

// GetCachedResources indicates an expected call of GetCachedResources.
func (mr *MockDataSourceManagerMockRecorder) GetCachedResources() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCachedResources", reflect.TypeOf((*MockDataSourceManager)(nil).GetCachedResources))
}

// LockQuery mocks base method.
func (m *MockDataSourceManager) LockQuery(ctx context.Context, param rm.LockQueryParam) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LockQuery", ctx, param)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LockQuery indicates an expected call of LockQuery.
func (mr *MockDataSourceManagerMockRecorder) LockQuery(ctx, param interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LockQuery", reflect.TypeOf((*MockDataSourceManager)(nil).LockQuery), ctx, param)
}

// RegisterResource mocks base method.
func (m *MockDataSourceManager) RegisterResource(resource rm.Resource) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterResource", resource)
	ret0, _ := ret[0].(error)
	return ret0
}

// RegisterResource indicates an expected call of RegisterResource.
func (mr *MockDataSourceManagerMockRecorder) RegisterResource(resource interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterResource", reflect.TypeOf((*MockDataSourceManager)(nil).RegisterResource), resource)
}

// UnregisterResource mocks base method.
func (m *MockDataSourceManager) UnregisterResource(resource rm.Resource) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UnregisterResource", resource)
	ret0, _ := ret[0].(error)
	return ret0
}

// UnregisterResource indicates an expected call of UnregisterResource.
func (mr *MockDataSourceManagerMockRecorder) UnregisterResource(resource interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UnregisterResource", reflect.TypeOf((*MockDataSourceManager)(nil).UnregisterResource), resource)
}

// MockTableMetaCache is a mock of TableMetaCache interface.
type MockTableMetaCache struct {
	ctrl     *gomock.Controller
	recorder *MockTableMetaCacheMockRecorder
}

// MockTableMetaCacheMockRecorder is the mock recorder for MockTableMetaCache.
type MockTableMetaCacheMockRecorder struct {
	mock *MockTableMetaCache
}

// NewMockTableMetaCache creates a new mock instance.
func NewMockTableMetaCache(ctrl *gomock.Controller) *MockTableMetaCache {
	mock := &MockTableMetaCache{ctrl: ctrl}
	mock.recorder = &MockTableMetaCacheMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockTableMetaCache) EXPECT() *MockTableMetaCacheMockRecorder {
	return m.recorder
}

// Destroy mocks base method.
func (m *MockTableMetaCache) Destroy() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Destroy")
	ret0, _ := ret[0].(error)
	return ret0
}

// Destroy indicates an expected call of Destroy.
func (mr *MockTableMetaCacheMockRecorder) Destroy() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Destroy", reflect.TypeOf((*MockTableMetaCache)(nil).Destroy))
}

// GetTableMeta mocks base method.
func (m *MockTableMetaCache) GetTableMeta(ctx context.Context, dbName, table string) (*types.TableMeta, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTableMeta", ctx, dbName, table)
	ret0, _ := ret[0].(*types.TableMeta)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTableMeta indicates an expected call of GetTableMeta.
func (mr *MockTableMetaCacheMockRecorder) GetTableMeta(ctx, dbName, table interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTableMeta", reflect.TypeOf((*MockTableMetaCache)(nil).GetTableMeta), ctx, dbName, table)
}

// Init mocks base method.
func (m *MockTableMetaCache) Init(ctx context.Context, conn *sql.DB) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Init", ctx, conn)
	ret0, _ := ret[0].(error)
	return ret0
}

// Init indicates an expected call of Init.
func (mr *MockTableMetaCacheMockRecorder) Init(ctx, conn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Init", reflect.TypeOf((*MockTableMetaCache)(nil).Init), ctx, conn)
}
