/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.load;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.common.Response;
import org.apache.hugegraph.controller.BaseController;
import org.apache.hugegraph.entity.GraphConnection;
import org.apache.hugegraph.entity.enums.JobStatus;
import org.apache.hugegraph.entity.load.FileMapping;
import org.apache.hugegraph.entity.load.JobManager;
import org.apache.hugegraph.entity.load.LoadTask;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.service.GraphConnectionService;
import org.apache.hugegraph.service.load.FileMappingService;
import org.apache.hugegraph.service.load.JobManagerService;
import org.apache.hugegraph.service.load.LoadTaskService;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/job-manager/{jobId}/load-tasks"})
public class LoadTaskController
extends BaseController {
    private static final Logger log = LogManager.getLogger(LoadTaskController.class);
    private static final int LIMIT = 500;
    @Autowired
    private GraphConnectionService connService;
    @Autowired
    private FileMappingService fmService;
    @Autowired
    private JobManagerService jobService;
    private final LoadTaskService service;

    @Autowired
    public LoadTaskController(LoadTaskService service) {
        this.service = service;
    }

    @GetMapping
    public IPage<LoadTask> list(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(name="page_no", required=false, defaultValue="1") int pageNo, @RequestParam(name="page_size", required=false, defaultValue="10") int pageSize) {
        return this.service.list(connId, jobId, pageNo, pageSize);
    }

    @GetMapping(value={"ids"})
    public List<LoadTask> list(@PathVariable(value="connId") int connId, @RequestParam(value="task_ids") List<Integer> taskIds) {
        return this.service.list(connId, taskIds);
    }

    @GetMapping(value={"{id}"})
    public LoadTask get(@PathVariable(value="id") int id) {
        LoadTask task = this.service.get(id);
        if (task == null) {
            throw new ExternalException("load.task.not-exist.id", id);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    public LoadTask create(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestBody LoadTask entity) {
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.SETTING, "load.task.create.no-permission", new Object[0]);
        LoadTaskService loadTaskService = this.service;
        synchronized (loadTaskService) {
            Ex.check(this.service.count() < 500, "load.task.reached-limit", 500);
            entity.setConnId(connId);
            this.service.save(entity);
        }
        return entity;
    }

    @DeleteMapping(value={"{id}"})
    public void delete(@PathVariable(value="id") int id) {
        LoadTask task = this.service.get(id);
        if (task == null) {
            throw new ExternalException("load.task.not-exist.id", id);
        }
        this.service.remove(id);
    }

    @PostMapping(value={"start"})
    public List<LoadTask> start(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(value="file_mapping_ids") List<Integer> fileIds) {
        GraphConnection connection = this.connService.get(connId);
        if (connection == null) {
            throw new ExternalException("graph-connection.not-exist.id", connId);
        }
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.SETTING, "load.task.start.no-permission", new Object[0]);
        boolean existError = false;
        try {
            ArrayList<LoadTask> tasks = new ArrayList<LoadTask>();
            for (Integer fileId : fileIds) {
                FileMapping fileMapping = this.fmService.get(fileId);
                if (fileMapping == null) {
                    throw new ExternalException("file-mapping.not-exist.id", fileId);
                }
                tasks.add(this.service.start(connection, fileMapping));
            }
            ArrayList<LoadTask> arrayList = tasks;
            return arrayList;
        }
        catch (Exception e) {
            existError = true;
            throw e;
        }
        finally {
            if (existError) {
                jobEntity.setJobStatus(JobStatus.FAILED);
            } else {
                jobEntity.setJobStatus(JobStatus.LOADING);
            }
            jobEntity.setUpdateTime(HubbleUtil.nowDate());
            this.jobService.update(jobEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"pause"})
    public LoadTask pause(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(value="task_id") int taskId) {
        GraphConnection connection = this.connService.get(connId);
        if (connection == null) {
            throw new ExternalException("graph-connection.not-exist.id", connId);
        }
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.LOADING, "load.task.pause.no-permission", new Object[0]);
        try {
            LoadTask loadTask = this.service.pause(taskId);
            return loadTask;
        }
        finally {
            jobEntity.setJobStatus(JobStatus.LOADING);
            jobEntity.setUpdateTime(HubbleUtil.nowDate());
            this.jobService.update(jobEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"resume"})
    public LoadTask resume(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(value="task_id") int taskId) {
        GraphConnection connection = this.connService.get(connId);
        if (connection == null) {
            throw new ExternalException("graph-connection.not-exist.id", connId);
        }
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.LOADING, "load.task.pause.no-permission", new Object[0]);
        try {
            LoadTask loadTask = this.service.resume(taskId);
            return loadTask;
        }
        finally {
            jobEntity.setJobStatus(JobStatus.LOADING);
            jobEntity.setUpdateTime(HubbleUtil.nowDate());
            this.jobService.update(jobEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"stop"})
    public LoadTask stop(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(value="task_id") int taskId) {
        GraphConnection connection = this.connService.get(connId);
        if (connection == null) {
            throw new ExternalException("graph-connection.not-exist.id", connId);
        }
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.LOADING, "load.task.pause.no-permission", new Object[0]);
        try {
            LoadTask loadTask = this.service.stop(taskId);
            return loadTask;
        }
        finally {
            jobEntity.setJobStatus(JobStatus.LOADING);
            jobEntity.setUpdateTime(HubbleUtil.nowDate());
            this.jobService.update(jobEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"retry"})
    public LoadTask retry(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(value="task_id") int taskId) {
        GraphConnection connection = this.connService.get(connId);
        if (connection == null) {
            throw new ExternalException("graph-connection.not-exist.id", connId);
        }
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.LOADING, "load.task.pause.no-permission", new Object[0]);
        try {
            LoadTask loadTask = this.service.retry(taskId);
            return loadTask;
        }
        finally {
            jobEntity.setJobStatus(JobStatus.LOADING);
            jobEntity.setUpdateTime(HubbleUtil.nowDate());
            this.jobService.update(jobEntity);
        }
    }

    @GetMapping(value={"{id}/reason"})
    public Response reason(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @PathVariable(value="id") int id) {
        LoadTask task = this.service.get(id);
        if (task == null) {
            throw new ExternalException("load.task.not-exist.id", id);
        }
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Integer fileId = task.getFileId();
        FileMapping mapping = this.fmService.get(fileId);
        String reason = this.service.readLoadFailedReason(mapping);
        return Response.builder().status(200).data(reason).build();
    }
}

