/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.filter;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.filter.ElementParser;
import org.apache.hugegraph.loader.filter.util.SegmentIdGenerator;
import org.apache.hugegraph.loader.filter.util.ShortIdConfig;
import org.apache.hugegraph.loader.util.DataTypeUtil;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.constant.DataType;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;

public class ShortIdParser
implements ElementParser {
    private Map<String, String> labels;
    private Map<byte[], byte[]> map;
    private ThreadLocal<SegmentIdGenerator.Context> idPool;
    private SegmentIdGenerator segmentIdGenerator;
    private LoadOptions options;
    private Map<String, ShortIdConfig> configs;

    public ShortIdParser(LoadOptions options) {
        this.options = options;
        this.labels = new HashMap<String, String>();
        this.configs = this.convertShortIdConfigs();
        this.map = new HashMap<byte[], byte[]>();
        this.idPool = new ThreadLocal();
        this.segmentIdGenerator = new SegmentIdGenerator();
    }

    public Map<String, ShortIdConfig> convertShortIdConfigs() {
        HashMap<String, ShortIdConfig> map = new HashMap<String, ShortIdConfig>();
        for (ShortIdConfig config : this.options.shorterIDConfigs) {
            map.put(config.getVertexLabel(), config);
            this.labels.put(config.getVertexLabel(), config.getVertexLabel());
        }
        return map;
    }

    @Override
    public boolean parse(GraphElement element) {
        if (element instanceof Edge) {
            ShortIdConfig config;
            Edge edge = (Edge)element;
            String label = this.labels.get(edge.sourceLabel());
            if (label != null) {
                config = this.configs.get(edge.sourceLabel());
                edge.sourceId((Object)this.getVertexNewId(label, ShortIdParser.idToBytes(config, edge.sourceId())));
            }
            if ((label = this.labels.get(edge.targetLabel())) != null) {
                config = this.configs.get(edge.targetLabel());
                edge.targetId((Object)this.getVertexNewId(label, ShortIdParser.idToBytes(config, edge.targetId())));
            }
        } else {
            Vertex vertex = (Vertex)element;
            if (this.configs.containsKey(vertex.label())) {
                ShortIdConfig config = this.configs.get(vertex.label());
                String idField = config.getIdFieldName();
                Object originId = vertex.id();
                if (originId == null) {
                    originId = vertex.property(config.getPrimaryKeyField());
                }
                vertex.property(idField, originId);
                vertex.id((Object)this.getVertexNewId(config.getVertexLabel(), ShortIdParser.idToBytes(config, originId)));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getVertexNewId(String label, byte[] oldId) {
        byte[] key = oldId;
        byte[] value = this.map.get(key);
        if (value == null) {
            ShortIdParser shortIdParser = this;
            synchronized (shortIdParser) {
                if (!this.map.containsKey(key)) {
                    int id = this.newID();
                    byte[] labelBytes = label.getBytes(StandardCharsets.UTF_8);
                    byte[] combined = new byte[labelBytes.length + oldId.length];
                    System.arraycopy(labelBytes, 0, combined, 0, labelBytes.length);
                    System.arraycopy(oldId, 0, combined, labelBytes.length, oldId.length);
                    this.map.put(combined, ShortIdParser.longToBytes(id));
                    return id;
                }
                value = this.map.get(key);
            }
        }
        return (int)ShortIdParser.bytesToLong(value);
    }

    public static byte[] idToBytes(ShortIdConfig config, Object obj) {
        DataType type = config.getIdFieldType();
        if (type.isText()) {
            String id = obj.toString();
            return id.getBytes(StandardCharsets.UTF_8);
        }
        if (type.isUUID()) {
            UUID id = DataTypeUtil.parseUUID("Id", obj);
            byte[] b = new byte[16];
            return ByteBuffer.wrap(b).order(ByteOrder.BIG_ENDIAN).putLong(id.getMostSignificantBits()).putLong(id.getLeastSignificantBits()).array();
        }
        if (type.isNumber()) {
            long id = DataTypeUtil.parseNumber("Id", obj);
            return ShortIdParser.longToBytes(id);
        }
        throw new LoadException("Unknow Id data type '%s'.", type.string());
    }

    public static byte[] stringToBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] longToBytes(long x) {
        return new byte[]{(byte)(x >>> 56), (byte)(x >>> 48), (byte)(x >>> 40), (byte)(x >>> 32), (byte)(x >>> 24), (byte)(x >>> 16), (byte)(x >>> 8), (byte)x};
    }

    public static long bytesToLong(byte[] bytes) {
        return (long)(bytes[0] << 56) | (long)(bytes[1] << 48) | (long)(bytes[2] << 40) | (long)(bytes[3] << 32) | (long)(bytes[4] << 24) | (long)(bytes[5] << 16) | (long)(bytes[6] << 8) | (long)bytes[7];
    }

    int newID() {
        SegmentIdGenerator.Context context = this.idPool.get();
        if (context == null) {
            context = this.segmentIdGenerator.genContext();
            this.idPool.set(context);
        }
        return context.next();
    }
}

