/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.stages;

import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.hugegraph.store.business.itrv2.TypeTransIterator;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResultType;
import org.apache.hugegraph.store.query.BaseElementComparator;
import org.apache.hugegraph.structure.BaseElement;

public class TopStage
implements QueryStage {
    private PriorityBlockingQueue<BaseElement> queue;
    private BaseElementComparator comparator;
    private boolean isAsc;
    private int limit;

    public void init(Object ... objects) {
        this.limit = (Integer)objects[0];
        this.isAsc = (Boolean)objects[2];
        this.comparator = new BaseElementComparator(QueryUtil.fromStringBytes((List)((List)objects[1])), !this.isAsc);
        this.queue = new PriorityBlockingQueue(this.limit, this.comparator);
    }

    public boolean isIterator() {
        return true;
    }

    public Iterator<PipelineResult> handleIterator(PipelineResult result) {
        if (result == null) {
            return null;
        }
        if (result.isEmpty()) {
            this.comparator.reverseOrder();
            PriorityQueue reverseQueue = new PriorityQueue(this.comparator);
            reverseQueue.addAll(this.queue);
            this.queue.clear();
            return new TypeTransIterator((Iterator)new /* Unavailable Anonymous Inner Class!! */, PipelineResult::new, () -> PipelineResult.EMPTY).toIterator();
        }
        if (result.getResultType() == PipelineResultType.HG_ELEMENT) {
            if (this.queue.size() < this.limit) {
                this.queue.add(result.getElement());
            } else {
                BaseElement top = (BaseElement)this.queue.peek();
                BaseElement element = result.getElement();
                if (this.comparator.compare(element, top) > 0) {
                    this.queue.poll();
                    this.queue.add(result.getElement());
                }
            }
        }
        return null;
    }

    public String getName() {
        return "TOP_STAGE";
    }

    public void close() {
        this.queue.clear();
    }
}

