/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.Util;

final class CompletionTokenStream
extends TokenStream {
    private final PayloadAttribute payloadAttr = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    private final PositionIncrementAttribute posAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final ByteTermAttribute bytesAtt = (ByteTermAttribute)this.addAttribute(ByteTermAttribute.class);
    private final TokenStream input;
    private final boolean preserveSep;
    private final boolean preservePositionIncrements;
    private final int sepLabel;
    private final int maxGraphExpansions;
    private BytesRef payload;
    private Iterator<IntsRef> finiteStrings;
    private int posInc = -1;
    private CharTermAttribute charTermAttribute;

    public CompletionTokenStream(TokenStream input) {
        this(input, true, true, 31, -1);
    }

    CompletionTokenStream(TokenStream input, boolean preserveSep, boolean preservePositionIncrements, int sepLabel, int maxGraphExpansions) {
        this.input = input;
        this.preserveSep = preserveSep;
        this.preservePositionIncrements = preservePositionIncrements;
        this.sepLabel = sepLabel;
        this.maxGraphExpansions = maxGraphExpansions;
    }

    public int sepLabel() {
        return this.sepLabel;
    }

    public void setPayload(BytesRef payload) {
        this.payload = payload;
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (this.finiteStrings == null) {
            Automaton automaton = this.toAutomaton(this.input);
            Set strings = Operations.getFiniteStrings((Automaton)automaton, (int)this.maxGraphExpansions);
            this.posInc = strings.size();
            this.finiteStrings = strings.iterator();
        }
        if (this.finiteStrings.hasNext()) {
            this.posAttr.setPositionIncrement(this.posInc);
            this.posInc = 0;
            Util.toBytesRef((IntsRef)this.finiteStrings.next(), (BytesRefBuilder)this.bytesAtt.builder());
            if (this.charTermAttribute != null) {
                this.charTermAttribute.setLength(0);
                this.charTermAttribute.append(this.bytesAtt.toUTF16());
            }
            if (this.payload != null) {
                this.payloadAttr.setPayload(this.payload);
            }
            return true;
        }
        return false;
    }

    public void end() throws IOException {
        super.end();
        if (this.posInc == -1) {
            this.input.end();
        }
    }

    public void close() throws IOException {
        if (this.posInc == -1) {
            this.input.close();
        }
    }

    public void reset() throws IOException {
        super.reset();
        if (this.hasAttribute(CharTermAttribute.class)) {
            this.charTermAttribute = (CharTermAttribute)this.getAttribute(CharTermAttribute.class);
        }
        this.finiteStrings = null;
        this.posInc = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Automaton toAutomaton(TokenStream tokenStream) throws IOException {
        Automaton automaton = null;
        try {
            TokenStreamToAutomaton tsta = this.preserveSep ? new EscapingTokenStreamToAutomaton('\u001f') : new TokenStreamToAutomaton();
            tsta.setPreservePositionIncrements(this.preservePositionIncrements);
            automaton = tsta.toAutomaton(tokenStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{tokenStream});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{tokenStream});
        automaton = CompletionTokenStream.replaceSep(automaton, this.preserveSep, 31);
        return Operations.determinize((Automaton)automaton, (int)this.maxGraphExpansions);
    }

    private static Automaton replaceSep(Automaton a, boolean preserveSep, int sepLabel) {
        Automaton result = new Automaton();
        int numStates = a.getNumStates();
        for (int s = 0; s < numStates; ++s) {
            result.createState();
            result.setAccept(s, a.isAccept(s));
        }
        Transition t = new Transition();
        int[] topoSortStates = CompletionTokenStream.topoSortStates(a);
        for (int i = 0; i < topoSortStates.length; ++i) {
            int state = topoSortStates[topoSortStates.length - 1 - i];
            int count = a.initTransition(state, t);
            for (int j = 0; j < count; ++j) {
                a.getNextTransition(t);
                if (t.min == 31) {
                    assert (t.max == 31);
                    if (preserveSep) {
                        result.addTransition(state, t.dest, sepLabel);
                        continue;
                    }
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                if (t.min == 30) {
                    assert (t.max == 30);
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                result.addTransition(state, t.dest, t.min, t.max);
            }
        }
        result.finishState();
        return result;
    }

    private static int[] topoSortStates(Automaton a) {
        int[] states = new int[a.getNumStates()];
        HashSet<Integer> visited = new HashSet<Integer>();
        LinkedList<Integer> worklist = new LinkedList<Integer>();
        worklist.add(0);
        visited.add(0);
        int upto = 0;
        states[upto] = 0;
        ++upto;
        Transition t = new Transition();
        while (worklist.size() > 0) {
            int s = (Integer)worklist.removeFirst();
            int count = a.initTransition(s, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (visited.contains(t.dest)) continue;
                visited.add(t.dest);
                worklist.add(t.dest);
                states[upto++] = t.dest;
            }
        }
        return states;
    }

    public static final class ByteTermAttributeImpl
    extends AttributeImpl
    implements ByteTermAttribute,
    TermToBytesRefAttribute {
        private final BytesRefBuilder bytes = new BytesRefBuilder();
        private CharsRefBuilder charsRef;

        public void fillBytesRef() {
        }

        @Override
        public BytesRefBuilder builder() {
            return this.bytes;
        }

        public BytesRef getBytesRef() {
            return this.bytes.get();
        }

        public void clear() {
            this.bytes.clear();
        }

        public void copyTo(AttributeImpl target) {
            ByteTermAttributeImpl other = (ByteTermAttributeImpl)target;
            other.bytes.copyBytes(this.bytes);
        }

        @Override
        public CharSequence toUTF16() {
            if (this.charsRef == null) {
                this.charsRef = new CharsRefBuilder();
            }
            this.charsRef.copyUTF8Bytes(this.getBytesRef());
            return this.charsRef.get();
        }
    }

    public static interface ByteTermAttribute
    extends TermToBytesRefAttribute {
        public BytesRefBuilder builder();

        public CharSequence toUTF16();
    }

    private static final class EscapingTokenStreamToAutomaton
    extends TokenStreamToAutomaton {
        final BytesRefBuilder spare = new BytesRefBuilder();
        private char sepLabel;

        public EscapingTokenStreamToAutomaton(char sepLabel) {
            this.sepLabel = sepLabel;
        }

        protected BytesRef changeToken(BytesRef in) {
            int upto = 0;
            for (int i = 0; i < in.length; ++i) {
                byte b = in.bytes[in.offset + i];
                if (b == (byte)this.sepLabel) {
                    this.spare.grow(upto + 2);
                    this.spare.setByteAt(upto++, (byte)this.sepLabel);
                    this.spare.setByteAt(upto++, b);
                    continue;
                }
                this.spare.grow(upto + 1);
                this.spare.setByteAt(upto++, b);
            }
            this.spare.setLength(upto);
            return this.spare.get();
        }
    }
}

