/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.profile;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.HugeAuthenticator;
import org.apache.hugegraph.auth.HugeGraphAuthProxy;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.space.GraphSpace;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.GraphReadMode;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/graphs")
@Singleton
@Tag(name="GraphsAPI")
public class GraphsAPI
extends API {
    private static final Logger LOG = Log.logger(GraphsAPI.class);
    private static final String CONFIRM_CLEAR = "I'm sure to delete all data";
    private static final String CONFIRM_DROP = "I'm sure to drop the graph";
    private static final String GRAPH_DESCRIPTION = "description";
    private static final String GRAPH_ACTION = "action";
    private static final String GRAPH_ACTION_RELOAD = "reload";

    private static Map<String, Object> convConfig(Map<String, Object> config) {
        HashMap<String, Object> result = new HashMap<String, Object>(config.size());
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space_member", "$dynamic"})
    public Object list(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @Context SecurityContext sc) {
        LOG.debug("List graphs in graph space {}", (Object)graphSpace);
        if (null == manager.graphSpace(graphSpace)) {
            throw new HugeException("Graphspace not exist!");
        }
        Set<String> graphs = manager.graphs(graphSpace);
        LOG.debug("Get graphs list from graph manager with size {}", (Object)graphs.size());
        HashSet<String> filterGraphs = new HashSet<String>();
        for (String graph : graphs) {
            LOG.debug("Get graph {} and verify auth", (Object)graph);
            String role = HugeAuthenticator.RequiredPerm.roleFor(graphSpace, graph, HugePermission.READ);
            if (sc.isUserInRole(role)) {
                try {
                    GraphsAPI.graph(manager, graphSpace, graph);
                    filterGraphs.add(graph);
                }
                catch (ForbiddenException forbiddenException) {}
                continue;
            }
            LOG.debug("The user not in role for graph {}", (Object)graph);
        }
        LOG.debug("Finish list graphs with size {}", (Object)filterGraphs.size());
        return ImmutableMap.of((Object)"graphs", filterGraphs);
    }

    @GET
    @Timed
    @Path(value="{name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space_member", "$owner=$name"})
    public Object get(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name) {
        LOG.debug("Get graph by name '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        return ImmutableMap.of((Object)"name", (Object)g.name(), (Object)"backend", (Object)g.backend());
    }

    @DELETE
    @Timed
    @Path(value="{name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space"})
    public void drop(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name, @QueryParam(value="confirm_message") String message) {
        LOG.debug("Drop graph by name '{}'", (Object)name);
        E.checkArgument((boolean)CONFIRM_DROP.equals(message), (String)"Please take the message: %s", (Object[])new Object[]{CONFIRM_DROP});
        manager.dropGraph(graphSpace, name, true);
    }

    @PUT
    @Timed
    @Path(value="manage")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"analyst"})
    public Object reload(@Context GraphManager manager, Map<String, String> actionMap) {
        LOG.info("[SERVER] Manage graph with action map {}", actionMap);
        E.checkArgument((actionMap != null && actionMap.containsKey(GRAPH_ACTION) ? 1 : 0) != 0, (String)"Please pass '%s' for graphs manage", (Object[])new Object[]{GRAPH_ACTION});
        String action = actionMap.get(GRAPH_ACTION);
        if (action.equals(GRAPH_ACTION_RELOAD)) {
            manager.reload();
            return ImmutableMap.of((Object)"graphs", (Object)"reloaded");
        }
        throw new AssertionError((Object)String.format("Invalid graphs action: '%s'", action));
    }

    @POST
    @Timed
    @Path(value="{name}")
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space"})
    public Object create(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name, @QueryParam(value="clone_graph_name") String clone, Map<String, Object> configs) {
        HugeGraph graph;
        LOG.debug("Create graph {} with config options '{}' in graph space '{}'", new Object[]{name, configs, graphSpace});
        GraphSpace gs = manager.graphSpace(graphSpace);
        E.checkArgumentNotNull((Object)gs, (String)"Not existed graph space: '%s'", (Object[])new Object[]{graphSpace});
        if (StringUtils.isEmpty((CharSequence)clone)) {
            String[] requiredKeys;
            E.checkArgument((configs != null ? 1 : 0) != 0, (String)"Config parameters cannot be null", (Object[])new Object[0]);
            for (String key : requiredKeys = new String[]{"backend", "serializer", "store"}) {
                Object value = configs.get(key);
                E.checkArgument((value instanceof String && !StringUtils.isEmpty((CharSequence)((String)value)) ? 1 : 0) != 0, (String)"Required parameter '%s' is missing or empty", (Object[])new Object[]{key});
            }
        }
        String creator = HugeGraphAuthProxy.getContext().user().username();
        if (StringUtils.isNotEmpty((CharSequence)clone)) {
            LOG.debug("Clone graph '{}' to '{}' in graph space '{}'", new Object[]{clone, name, graphSpace});
            graph = manager.cloneGraph(graphSpace, clone, name, GraphsAPI.convConfig(configs));
        } else {
            graph = manager.createGraph(graphSpace, name, creator, GraphsAPI.convConfig(configs), true);
        }
        String description = (String)configs.get(GRAPH_DESCRIPTION);
        if (description == null) {
            description = "";
        }
        ImmutableMap result = ImmutableMap.of((Object)"name", (Object)graph.name(), (Object)"nickname", (Object)graph.nickname(), (Object)"backend", (Object)graph.backend(), (Object)GRAPH_DESCRIPTION, (Object)description);
        LOG.info("user [{}] create graph [{}] in graph space [{}] with config [{}]", new Object[]{creator, name, graphSpace, configs});
        return result;
    }

    @GET
    @Timed
    @Path(value="{name}/conf")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space"})
    public File getConf(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name) {
        LOG.debug("Get graph configuration by name '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        HugeConfig config = (HugeConfig)g.configuration();
        File file = config.file();
        if (file == null) {
            throw new NotSupportedException("Can't access the api in a node which started with non local file config.");
        }
        return file;
    }

    @DELETE
    @Timed
    @Path(value="{name}/clear")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"space"})
    public void clear(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name, @QueryParam(value="confirm_message") String message) {
        LOG.debug("Clear graph by name '{}'", (Object)name);
        E.checkArgument((boolean)CONFIRM_CLEAR.equals(message), (String)"Please take the message: %s", (Object[])new Object[]{CONFIRM_CLEAR});
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        g.truncateBackend();
    }

    @PUT
    @Timed
    @Path(value="{name}/snapshot_create")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space", "$owner=$name"})
    public Object createSnapshot(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name) {
        LOG.debug("Create snapshot for graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        g.createSnapshot();
        return ImmutableMap.of((Object)name, (Object)"snapshot_created");
    }

    @PUT
    @Timed
    @Path(value="{name}/snapshot_resume")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space", "$owner=$name"})
    public Object resumeSnapshot(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name) {
        LOG.debug("Resume snapshot for graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        g.resumeSnapshot();
        return ImmutableMap.of((Object)name, (Object)"snapshot_resumed");
    }

    @PUT
    @Timed
    @Path(value="{name}/compact")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space"})
    public String compact(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name) {
        LOG.debug("Manually compact graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        return JsonUtil.toJson((Object)g.metadata(null, "compact", new Object[0]));
    }

    @PUT
    @Timed
    @Path(value="{name}/mode")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space", "$owner=$name"})
    public Map<String, GraphMode> mode(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name, GraphMode mode) {
        LOG.debug("Set mode to: '{}' of graph '{}'", (Object)mode, (Object)name);
        E.checkArgument((mode != null ? 1 : 0) != 0, (String)"Graph mode can't be null", (Object[])new Object[0]);
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        g.mode(mode);
        return ImmutableMap.of((Object)"mode", (Object)mode);
    }

    @GET
    @Timed
    @Path(value="{name}/mode")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space_member", "$owner=$name"})
    public Map<String, GraphMode> mode(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name) {
        LOG.debug("Get mode of graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        return ImmutableMap.of((Object)"mode", (Object)g.mode());
    }

    @PUT
    @Timed
    @Path(value="{name}/graph_read_mode")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space"})
    public Map<String, GraphReadMode> graphReadMode(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name, GraphReadMode readMode) {
        LOG.debug("Set graph-read-mode to: '{}' of graph '{}'", (Object)readMode, (Object)name);
        E.checkArgument((readMode != null ? 1 : 0) != 0, (String)"Graph-read-mode can't be null", (Object[])new Object[0]);
        E.checkArgument((readMode == GraphReadMode.ALL || readMode == GraphReadMode.OLTP_ONLY ? 1 : 0) != 0, (String)"Graph-read-mode could be ALL or OLTP_ONLY", (Object[])new Object[0]);
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        manager.graphReadMode(graphSpace, name, readMode);
        g.readMode(readMode);
        return ImmutableMap.of((Object)"graph_read_mode", (Object)readMode);
    }

    @GET
    @Timed
    @Path(value="{name}/graph_read_mode")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"space_member", "$owner=$name"})
    public Map<String, GraphReadMode> graphReadMode(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="name") String name) {
        LOG.debug("Get graph-read-mode of graph '{}'", (Object)name);
        HugeGraph g = GraphsAPI.graph(manager, graphSpace, name);
        return ImmutableMap.of((Object)"graph_read_mode", (Object)g.readMode());
    }
}

