/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.arthas;

import com.codahale.metrics.annotation.Timed;
import com.taobao.arthas.agent.attach.ArthasAgent;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.HashMap;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.util.JsonUtil;

@Path(value="arthas")
@Singleton
@Tag(name="ArthasAPI")
public class ArthasAPI
extends API {
    @Context
    private Provider<HugeConfig> configProvider;

    @PUT
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="start arthas agent")
    public Object startArthas() {
        HugeConfig config = (HugeConfig)this.configProvider.get();
        HashMap<String, String> configMap = new HashMap<String, String>(4);
        configMap.put("arthas.telnetPort", (String)config.get(ServerOptions.ARTHAS_TELNET_PORT));
        configMap.put("arthas.httpPort", (String)config.get(ServerOptions.ARTHAS_HTTP_PORT));
        configMap.put("arthas.ip", (String)config.get(ServerOptions.ARTHAS_IP));
        configMap.put("arthas.disabledCommands", (String)config.get(ServerOptions.ARTHAS_DISABLED_COMMANDS));
        ArthasAgent.attach(configMap);
        return JsonUtil.toJson(configMap);
    }
}

