/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatus;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatusFluent;
import java.util.Objects;

public class ContainerResourceMetricStatusFluentImpl<A extends ContainerResourceMetricStatusFluent<A>>
extends BaseFluent<A>
implements ContainerResourceMetricStatusFluent<A> {
    private String container;
    private Integer currentAverageUtilization;
    private Quantity currentAverageValue;
    private String name;

    public ContainerResourceMetricStatusFluentImpl() {
    }

    public ContainerResourceMetricStatusFluentImpl(ContainerResourceMetricStatus instance) {
        this.withContainer(instance.getContainer());
        this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization());
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withName(instance.getName());
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    @Override
    public Boolean hasContainer() {
        return this.container != null;
    }

    @Override
    @Deprecated
    public A withNewContainer(String arg0) {
        return this.withContainer(new String(arg0));
    }

    @Override
    public Integer getCurrentAverageUtilization() {
        return this.currentAverageUtilization;
    }

    @Override
    public A withCurrentAverageUtilization(Integer currentAverageUtilization) {
        this.currentAverageUtilization = currentAverageUtilization;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentAverageUtilization() {
        return this.currentAverageUtilization != null;
    }

    @Override
    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    @Override
    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    @Override
    public A withNewCurrentAverageValue(String amount, String format) {
        return this.withCurrentAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewCurrentAverageValue(String amount) {
        return this.withCurrentAverageValue(new Quantity(amount));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerResourceMetricStatusFluentImpl that = (ContainerResourceMetricStatusFluentImpl)o;
        if (this.container != null ? !this.container.equals(that.container) : that.container != null) {
            return false;
        }
        if (this.currentAverageUtilization != null ? !this.currentAverageUtilization.equals(that.currentAverageUtilization) : that.currentAverageUtilization != null) {
            return false;
        }
        if (this.currentAverageValue != null ? !this.currentAverageValue.equals((Object)that.currentAverageValue) : that.currentAverageValue != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.currentAverageUtilization, this.currentAverageValue, this.name, super.hashCode());
    }
}

