/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class TaskTransaction
extends GraphTransaction {
    public static final String TASK = HugeTask.P.TASK;

    public TaskTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
        this.autoCommit(true);
    }

    public HugeVertex constructVertex(HugeTask<?> task) {
        if (!this.graph().existsVertexLabel(TASK)) {
            throw new HugeException("Schema is missing for task(%s) '%s'", task.id(), task.name());
        }
        return this.constructVertex(false, task.asArray());
    }

    public void deleteIndex(HugeVertex vertex) {
        Iterator<Vertex> old = this.queryTaskInfos(vertex.id());
        HugeVertex oldV = (HugeVertex)QueryResults.one(old);
        if (oldV == null) {
            return;
        }
        this.deleteIndexIfNeeded(oldV, vertex);
    }

    private boolean deleteIndexIfNeeded(HugeVertex oldV, HugeVertex newV) {
        if (!oldV.value("~task_status").equals(newV.value("~task_status"))) {
            this.updateIndex(this.indexLabel("~task_status").id(), oldV, true);
            return true;
        }
        return false;
    }

    public void initSchema() {
        if (this.existVertexLabel(TASK)) {
            return;
        }
        HugeGraph graph = this.graph();
        String[] properties = this.initProperties();
        VertexLabel label = (VertexLabel)graph.schema().vertexLabel(TASK).properties(properties).useCustomizeNumberId().nullableKeys("~task_description", "~task_context", "~task_update", "~task_input", "~task_result", "~task_dependencies", "~task_server").enableLabelIndex(true).build();
        this.params().schemaTransaction().addVertexLabel(label);
        this.createIndexLabel(label, "~task_status");
    }

    private boolean existVertexLabel(String label) {
        return this.params().schemaTransaction().getVertexLabel(label) != null;
    }

    private String[] initProperties() {
        ArrayList<String> props = new ArrayList<String>();
        props.add(this.createPropertyKey("~task_type"));
        props.add(this.createPropertyKey("~task_name"));
        props.add(this.createPropertyKey("~task_callable"));
        props.add(this.createPropertyKey("~task_description"));
        props.add(this.createPropertyKey("~task_context"));
        props.add(this.createPropertyKey("~task_status", DataType.BYTE));
        props.add(this.createPropertyKey("~task_progress", DataType.INT));
        props.add(this.createPropertyKey("~task_create", DataType.DATE));
        props.add(this.createPropertyKey("~task_update", DataType.DATE));
        props.add(this.createPropertyKey("~task_retries", DataType.INT));
        props.add(this.createPropertyKey("~task_input", DataType.BLOB));
        props.add(this.createPropertyKey("~task_result", DataType.BLOB));
        props.add(this.createPropertyKey("~task_dependencies", DataType.LONG, Cardinality.SET));
        props.add(this.createPropertyKey("~task_server"));
        return props.toArray(new String[0]);
    }

    private String createPropertyKey(String name) {
        return this.createPropertyKey(name, DataType.TEXT);
    }

    private String createPropertyKey(String name, DataType dataType) {
        return this.createPropertyKey(name, dataType, Cardinality.SINGLE);
    }

    private String createPropertyKey(String name, DataType dataType, Cardinality cardinality) {
        HugeGraph graph = this.graph();
        SchemaManager schema = graph.schema();
        PropertyKey propertyKey = (PropertyKey)schema.propertyKey(name).dataType(dataType).cardinality(cardinality).build();
        this.params().schemaTransaction().addPropertyKey(propertyKey);
        return name;
    }

    private IndexLabel createIndexLabel(VertexLabel label, String field) {
        HugeGraph graph = this.graph();
        SchemaManager schema = graph.schema();
        String name = Graph.Hidden.hide((String)("task-index-by-" + field));
        IndexLabel indexLabel = (IndexLabel)schema.indexLabel(name).on(HugeType.VERTEX_LABEL, TASK).by(field).build();
        this.params().schemaTransaction().addIndexLabel(label, indexLabel);
        return indexLabel;
    }

    private IndexLabel indexLabel(String field) {
        String name = Graph.Hidden.hide((String)("task-index-by-" + field));
        HugeGraph graph = this.graph();
        return graph.indexLabel(name);
    }
}

