/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.lock;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hugegraph.meta.lock.LockResult;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class EtcdDistributedLock {
    protected static final Logger LOG = Log.logger(EtcdDistributedLock.class);
    private static final long UNLIMITED_TIMEOUT = -1L;
    private static final Object mutex = new Object();
    private static EtcdDistributedLock lockProvider = null;
    private final KV kvClient;
    private final Lock lockClient;
    private final Lease leaseClient;
    private static final int poolSize = 8;
    private final ScheduledExecutorService service = new ScheduledThreadPoolExecutor(8, r -> {
        Thread t = new Thread(r, "keepalive");
        t.setDaemon(true);
        return t;
    });

    private EtcdDistributedLock(Client client) {
        this.kvClient = client.getKVClient();
        this.lockClient = client.getLockClient();
        this.leaseClient = client.getLeaseClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EtcdDistributedLock getInstance(Client client) {
        Object object = mutex;
        synchronized (object) {
            if (null == lockProvider) {
                lockProvider = new EtcdDistributedLock(client);
            }
        }
        return lockProvider;
    }

    private static ByteSequence toByteSequence(String content) {
        return ByteSequence.from((String)content, (Charset)Charset.defaultCharset());
    }

    public LockResult tryLock(String lockName, long ttl, long timeout) {
        long leaseId;
        LockResult lockResult = new LockResult();
        lockResult.lockSuccess(false);
        lockResult.setService(this.service);
        try {
            leaseId = ((LeaseGrantResponse)this.leaseClient.grant(ttl).get()).getID();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(String.format("Thread {} failed to create lease for {} with ttl {}", Thread.currentThread().getName(), lockName, ttl), (Throwable)e);
            return lockResult;
        }
        lockResult.setLeaseId(leaseId);
        long period = ttl - ttl / 5L;
        this.service.scheduleAtFixedRate(new KeepAliveTask(this.leaseClient, leaseId), period, period, TimeUnit.SECONDS);
        try {
            if (timeout == -1L) {
                this.lockClient.lock(EtcdDistributedLock.toByteSequence(lockName), leaseId).get();
            } else {
                this.lockClient.lock(EtcdDistributedLock.toByteSequence(lockName), leaseId).get(1L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(String.format("Thread {} failed to lock {}", Thread.currentThread().getName(), lockName), (Throwable)e);
            this.service.shutdown();
            this.revokeLease(leaseId);
            return lockResult;
        }
        catch (TimeoutException e) {
            LOG.warn("Thread {} timeout to lock {}", (Object)Thread.currentThread().getName(), (Object)lockName);
            this.service.shutdown();
            this.revokeLease(leaseId);
            return lockResult;
        }
        lockResult.lockSuccess(true);
        return lockResult;
    }

    public LockResult lock(String lockName, long ttl) {
        return this.tryLock(lockName, ttl, -1L);
    }

    public void unLock(String lockName, LockResult lockResult) {
        LOG.debug("Thread {} start to unlock {}", (Object)Thread.currentThread().getName(), (Object)lockName);
        lockResult.getService().shutdown();
        if (lockResult.getLeaseId() != 0L) {
            this.revokeLease(lockResult.getLeaseId());
        }
        LOG.debug("Thread {} unlock {} successfully", (Object)Thread.currentThread().getName(), (Object)lockName);
    }

    private void revokeLease(long leaseId) {
        try {
            this.leaseClient.revoke(leaseId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(String.format("Thread %s failed to revoke release %s", Thread.currentThread().getName(), leaseId), (Throwable)e);
        }
    }

    public static class KeepAliveTask
    implements Runnable {
        private final Lease leaseClient;
        private final long leaseId;

        KeepAliveTask(Lease leaseClient, long leaseId) {
            this.leaseClient = leaseClient;
            this.leaseId = leaseId;
        }

        @Override
        public void run() {
            this.leaseClient.keepAliveOnce(this.leaseId);
        }
    }
}

