/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.pool.impl;

import org.apache.hugegraph.memory.MemoryManager;
import org.apache.hugegraph.memory.pool.AbstractMemoryPool;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.memory.pool.impl.MemoryPoolStats;
import org.apache.hugegraph.memory.pool.impl.TaskMemoryPool;
import org.apache.hugegraph.memory.util.RoundUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMemoryPool
extends AbstractMemoryPool {
    private static final Logger LOG = LoggerFactory.getLogger(QueryMemoryPool.class);
    private static final String TASK_MEMORY_POOL_NAME_PREFIX = "TaskMemoryPool";
    private static final String EXPAND_SELF = "expand self's max capacity";
    private static final String REQUEST_MEMORY = "request to allocate memory";

    public QueryMemoryPool(String poolName, MemoryManager memoryManager) {
        super(null, poolName, MemoryPoolStats.MemoryPoolType.QUERY, memoryManager);
        this.stats.setMaxCapacity(MemoryManager.MAX_MEMORY_CAPACITY_FOR_ONE_QUERY);
    }

    @Override
    public long tryToReclaimLocalMemory(long neededBytes, MemoryPool requestingPool) {
        if (this.isClosed) {
            LOG.warn("[{}] is already closed, will abort this reclaim", (Object)this);
            return 0L;
        }
        if (this.equals(requestingPool.findRootQueryPool())) {
            return super.tryToReclaimLocalMemoryWithoutLock(neededBytes, requestingPool);
        }
        return super.tryToReclaimLocalMemory(neededBytes, requestingPool);
    }

    @Override
    public MemoryPool addChildPool(String name) {
        int count = this.children.size();
        String poolName = "TaskMemoryPool_" + name + "_" + count + "_" + System.currentTimeMillis();
        TaskMemoryPool taskMemoryPool = new TaskMemoryPool(this, poolName, this.memoryManager);
        this.children.add(taskMemoryPool);
        LOG.info("QueryPool-{} added task memory pool {}", (Object)this, (Object)taskMemoryPool);
        return taskMemoryPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long requestMemoryInternal(long bytes, MemoryPool requestingPool) {
        if (this.isClosed) {
            LOG.warn("[{}] is already closed, will abort this request", (Object)this);
            return 0L;
        }
        long requestedMemoryFromManager = 0L;
        long requestedMemoryFromArbitration = 0L;
        this.memoryActionLock.lock();
        try {
            long neededDelta;
            if (this.isBeingArbitrated.get()) {
                this.condition.await();
            }
            if (this.getMaxCapacityBytes() - this.stats.getAllocatedBytes() < bytes) {
                neededDelta = bytes - (this.getMaxCapacityBytes() - this.stats.getAllocatedBytes());
                long managerReturnedMemoryInBytes = this.tryToExpandSelfCapacity(neededDelta);
                if (managerReturnedMemoryInBytes > 0L) {
                    this.stats.setMaxCapacity(this.getMaxCapacityBytes() + managerReturnedMemoryInBytes);
                    this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() + bytes);
                    this.stats.setNumExpands(this.stats.getNumExpands() + 1L);
                    requestedMemoryFromManager = bytes;
                } else {
                    requestedMemoryFromArbitration = this.requestMemoryThroughArbitration(bytes, requestingPool);
                }
            } else if (this.memoryManager.handleRequestFromQueryPool(bytes, REQUEST_MEMORY) < 0L) {
                requestedMemoryFromArbitration = this.requestMemoryThroughArbitration(bytes, requestingPool);
            } else {
                this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() + bytes);
                requestedMemoryFromManager = bytes;
            }
            if (requestedMemoryFromManager > 0L) {
                this.memoryManager.consumeAvailableMemory(requestedMemoryFromManager);
            }
            neededDelta = requestedMemoryFromManager == 0L ? requestedMemoryFromArbitration : requestedMemoryFromManager;
            return neededDelta;
        }
        catch (InterruptedException e) {
            LOG.error("[{}] Failed to request memory because ", (Object)this, (Object)e);
            Thread.currentThread().interrupt();
            long l = 0L;
            return l;
        }
        finally {
            this.memoryActionLock.unlock();
        }
    }

    private long tryToExpandSelfCapacity(long size) {
        LOG.debug("[{}] try to expand its capacity: size={}", (Object)this, (Object)size);
        long alignedSize = RoundUtil.sizeAlign(size);
        long realNeededSize = RoundUtil.roundDelta(this.getAllocatedBytes(), alignedSize);
        return this.memoryManager.handleRequestFromQueryPool(realNeededSize, EXPAND_SELF);
    }

    private long requestMemoryThroughArbitration(long bytes, MemoryPool requestingPool) {
        LOG.info("[{}] try to request memory from manager through arbitration: size={}, snapshot-[{}]", new Object[]{this, bytes, this.getSnapShot()});
        long reclaimedBytes = this.memoryManager.triggerLocalArbitration(this, bytes, requestingPool);
        if (reclaimedBytes - bytes >= 0L) {
            return reclaimedBytes;
        }
        long globalArbitrationNeededBytes = bytes - reclaimedBytes;
        long globalReclaimedBytes = this.memoryManager.triggerGlobalArbitration(this, globalArbitrationNeededBytes);
        reclaimedBytes += globalReclaimedBytes;
        if (globalReclaimedBytes != 0L) {
            this.stats.setMaxCapacity(this.stats.getMaxCapacity() + globalReclaimedBytes);
            this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() + globalReclaimedBytes);
            this.stats.setNumExpands(this.stats.getNumExpands() + 1L);
        }
        if (reclaimedBytes - bytes >= 0L) {
            return reclaimedBytes;
        }
        return -reclaimedBytes;
    }
}

