/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.consumer.impl.id;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Collections;
import java.util.List;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;

public class BinaryIdOffHeap
extends BinaryBackendEntry.BinaryId
implements OffHeapObject {
    private final OffHeapObject originId;
    private ByteBuf bytesOffHeap;

    public BinaryIdOffHeap(byte[] bytes, Id id, MemoryPool memoryPool, OffHeapObject originId) {
        super(bytes, id);
        this.originId = originId;
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    @Override
    public void serializeSelfToByteBuf(MemoryPool memoryPool) {
        this.bytesOffHeap = (ByteBuf)memoryPool.requireMemory(this.bytes.length, memoryPool);
        this.bytesOffHeap.markReaderIndex();
        this.bytesOffHeap.writeBytes(this.bytes);
    }

    @Override
    public BinaryBackendEntry.BinaryId zeroCopyReadFromByteBuf() {
        return new BinaryBackendEntry.BinaryId(ByteBufUtil.getBytes((ByteBuf)this.bytesOffHeap), (Id)this.originId.zeroCopyReadFromByteBuf());
    }

    @Override
    public List<ByteBuf> getAllMemoryBlock() {
        return Collections.singletonList(this.bytesOffHeap);
    }

    @Override
    public void releaseOriginalVarsOnHeap() {
        this.bytes = null;
        this.id = null;
    }

    @Override
    public Object asObject() {
        return this.bytesOffHeap.nioBuffer();
    }

    @Override
    public String toString() {
        return "0x" + Bytes.toHex((byte[])this.asBytes());
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BinaryIdOffHeap)) {
            return false;
        }
        return this.bytesOffHeap.equals((Object)((BinaryIdOffHeap)other).bytesOffHeap);
    }

    @Override
    public int hashCode() {
        return this.bytesOffHeap.hashCode();
    }

    @Override
    public int length() {
        return this.bytesOffHeap.readableBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] asBytes(int offset) {
        E.checkArgument((offset < this.bytesOffHeap.readableBytes() ? 1 : 0) != 0, (String)"Invalid offset %s, must be < length %s", (Object[])new Object[]{offset, this.bytesOffHeap.readableBytes()});
        try {
            byte[] tmpBytes = new byte[offset];
            this.bytesOffHeap.readBytes(tmpBytes);
            byte[] byArray = tmpBytes;
            return byArray;
        }
        finally {
            this.bytesOffHeap.resetReaderIndex();
        }
    }

    @Override
    public byte[] asBytes() {
        try {
            byte[] tmpBytes = new byte[this.bytesOffHeap.readableBytes()];
            this.bytesOffHeap.readBytes(tmpBytes);
            byte[] byArray = tmpBytes;
            return byArray;
        }
        finally {
            this.bytesOffHeap.resetReaderIndex();
        }
    }

    @Override
    public int compareTo(Id other) {
        return this.bytesOffHeap.compareTo(((BinaryIdOffHeap)other).bytesOffHeap);
    }

    @Override
    public Id origin() {
        return (Id)this.originId.zeroCopyReadFromByteBuf();
    }
}

