/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.fury.io;

import static org.testng.Assert.assertEquals;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.testng.annotations.Test;

public class MockOutputStreamTest {

  @Test
  public void testMockStream() throws IOException {
    try (MockOutputStream stream = new MockOutputStream(); ) {
      stream.write(new byte[100]);
      stream.write(new byte[100], 10, 20);
      stream.write(ByteBuffer.allocate(100), 50);
      assertEquals(stream.totalBytes(), 170);
    }
  }
}
