/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.sql.Date;
import java.sql.Time;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.TimeZone;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.utils.Preconditions;

public class DateTimeUtils {
    public static final int EPOCH_JULIAN = 2440588;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final DateTimeFormatter DEFAULT_TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-[MM][M]-[dd][d]").optionalStart().appendPattern(" [HH][H]:[mm][m]:[ss][s]").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().toFormatter();

    public static Date toSQLDate(int v) {
        long t = (long)v * 86400000L;
        return new Date(t - (long)TimeZone.getDefault().getOffset(t));
    }

    public static Time toSQLTime(int v) {
        return new Time(v - TimeZone.getDefault().getOffset(v));
    }

    public static int toInternal(Date date) {
        long ts = date.getTime() + (long)TimeZone.getDefault().getOffset(date.getTime());
        return (int)(ts / 86400000L);
    }

    public static int toInternal(Time time) {
        long ts = time.getTime() + (long)TimeZone.getDefault().getOffset(time.getTime());
        return (int)(ts % 86400000L);
    }

    public static Timestamp toInternal(long millis, int nanos) {
        return Timestamp.fromEpochMillis(millis + (long)TimeZone.getDefault().getOffset(millis), nanos);
    }

    public static int toInternal(LocalDate date) {
        return DateTimeUtils.ymdToUnixDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static int toInternal(LocalTime time) {
        return time.getHour() * 3600000 + time.getMinute() * 60000 + time.getSecond() * 1000 + time.getNano() / 1000000;
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime, int precision) {
        Preconditions.checkArgument(precision >= 0 && precision <= 9, "precision should be in range 0 ~ 9.");
        StringBuilder ymdhms = DateTimeUtils.ymdhms(new StringBuilder(), localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
        StringBuilder fraction = new StringBuilder(Long.toString(localDateTime.getNano()));
        while (fraction.length() < 9) {
            fraction.insert(0, "0");
        }
        String nano = fraction.substring(0, precision);
        if (nano.length() > 0) {
            ymdhms.append(".").append(nano);
        }
        return ymdhms.toString();
    }

    public static LocalDate toLocalDate(int date) {
        return DateTimeUtils.julianToLocalDate(date + 2440588);
    }

    private static LocalDate julianToLocalDate(int julian) {
        int j = julian + 32044;
        int g = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g * 400 + c * 100 + b * 4 + a;
        int m = (da * 5 + 308) / 153 - 2;
        int d = da - (m + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m + 2) / 12;
        int month = (m + 2) % 12 + 1;
        int day = d + 1;
        return LocalDate.of(year, month, day);
    }

    public static LocalTime toLocalTime(int time) {
        int h = time / 3600000;
        int time2 = time % 3600000;
        int m = time2 / 60000;
        int time3 = time2 % 60000;
        int s = time3 / 1000;
        int ms = time3 % 1000;
        return LocalTime.of(h, m, s, ms * 1000000);
    }

    public static Integer parseDate(String s) {
        int d;
        int m;
        int y;
        int hyphen1;
        int ws1 = s.indexOf(" ");
        if (ws1 > 0) {
            s = s.substring(0, ws1);
        }
        if ((hyphen1 = s.indexOf(45)) < 0) {
            if (!DateTimeUtils.isInteger(s.trim())) {
                return null;
            }
            y = Integer.parseInt(s.trim());
            m = 1;
            d = 1;
        } else {
            if (!DateTimeUtils.isInteger(s.substring(0, hyphen1).trim())) {
                return null;
            }
            y = Integer.parseInt(s.substring(0, hyphen1).trim());
            int hyphen2 = s.indexOf(45, hyphen1 + 1);
            if (hyphen2 < 0) {
                if (!DateTimeUtils.isInteger(s.substring(hyphen1 + 1).trim())) {
                    return null;
                }
                m = Integer.parseInt(s.substring(hyphen1 + 1).trim());
                d = 1;
            } else {
                if (!DateTimeUtils.isInteger(s.substring(hyphen1 + 1, hyphen2).trim())) {
                    return null;
                }
                m = Integer.parseInt(s.substring(hyphen1 + 1, hyphen2).trim());
                if (!DateTimeUtils.isInteger(s.substring(hyphen2 + 1).trim())) {
                    return null;
                }
                d = Integer.parseInt(s.substring(hyphen2 + 1).trim());
            }
        }
        if (!DateTimeUtils.isIllegalDate(y, m, d)) {
            return null;
        }
        return DateTimeUtils.ymdToUnixDate(y, m, d);
    }

    public static Integer parseTime(String v) {
        int milli;
        int second;
        int minute;
        int hour;
        int timezoneMinute;
        int timezoneHour;
        boolean start = false;
        int colon1 = v.indexOf(58, 0);
        int operator = -1;
        int end = v.length();
        int timezone = v.indexOf(45, 0);
        if (timezone < 0) {
            timezone = v.indexOf(43, 0);
            operator = 1;
        }
        if (timezone < 0) {
            timezoneHour = 0;
            timezoneMinute = 0;
        } else {
            end = timezone;
            int colon3 = v.indexOf(58, timezone);
            if (colon3 < 0) {
                if (!DateTimeUtils.isInteger(v.substring(timezone + 1).trim())) {
                    return null;
                }
                timezoneHour = Integer.parseInt(v.substring(timezone + 1).trim());
                timezoneMinute = 0;
            } else {
                if (!DateTimeUtils.isInteger(v.substring(timezone + 1, colon3).trim())) {
                    return null;
                }
                timezoneHour = Integer.parseInt(v.substring(timezone + 1, colon3).trim());
                if (!DateTimeUtils.isInteger(v.substring(colon3 + 1).trim())) {
                    return null;
                }
                timezoneMinute = Integer.parseInt(v.substring(colon3 + 1).trim());
            }
        }
        if (colon1 < 0) {
            if (!DateTimeUtils.isInteger(v.substring(0, end).trim())) {
                return null;
            }
            hour = Integer.parseInt(v.substring(0, end).trim());
            minute = 0;
            second = 0;
            milli = 0;
        } else {
            if (!DateTimeUtils.isInteger(v.substring(0, colon1).trim())) {
                return null;
            }
            hour = Integer.parseInt(v.substring(0, colon1).trim());
            int colon2 = v.indexOf(58, colon1 + 1);
            if (colon2 < 0) {
                if (!DateTimeUtils.isInteger(v.substring(colon1 + 1, end).trim())) {
                    return null;
                }
                minute = Integer.parseInt(v.substring(colon1 + 1, end).trim());
                second = 0;
                milli = 0;
            } else {
                if (!DateTimeUtils.isInteger(v.substring(colon1 + 1, colon2).trim())) {
                    return null;
                }
                minute = Integer.parseInt(v.substring(colon1 + 1, colon2).trim());
                int dot = v.indexOf(46, colon2);
                if (dot < 0) {
                    if (!DateTimeUtils.isInteger(v.substring(colon2 + 1, end).trim())) {
                        return null;
                    }
                    second = Integer.parseInt(v.substring(colon2 + 1, end).trim());
                    milli = 0;
                } else {
                    if (!DateTimeUtils.isInteger(v.substring(colon2 + 1, dot).trim())) {
                        return null;
                    }
                    second = Integer.parseInt(v.substring(colon2 + 1, dot).trim());
                    milli = DateTimeUtils.parseFraction(v.substring(dot + 1, end).trim());
                }
            }
        }
        return (hour += operator * timezoneHour) * 3600000 + (minute += operator * timezoneMinute) * 60000 + second * 1000 + milli;
    }

    private static boolean isInteger(String s) {
        boolean isInt = s.length() > 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) >= '0' && s.charAt(i) <= '9') continue;
            isInt = false;
            break;
        }
        return isInt;
    }

    private static boolean isIllegalDate(int y, int m, int d) {
        int[] monthOf31Days = new int[]{1, 3, 5, 7, 8, 10, 12};
        if (y < 0 || y > 9999 || m < 1 || m > 12 || d < 1 || d > 31) {
            return false;
        }
        if (!(m != 2 || d <= 28 || DateTimeUtils.isLeapYear(y) && d == 29)) {
            return false;
        }
        if (d == 31) {
            for (int i : monthOf31Days) {
                if (i != m) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static int parseFraction(String v) {
        int multiplier = 100;
        int r = 0;
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            int x = c < '0' || c > '9' ? 0 : c - 48;
            r += multiplier * x;
            if (multiplier < 10) {
                if (i + 1 >= v.length() || v.charAt(i + 1) < '5') break;
                ++r;
                break;
            }
            multiplier /= 10;
        }
        return r;
    }

    public static String formatTimestamp(Timestamp ts, int precision) {
        LocalDateTime ldt = ts.toLocalDateTime();
        String fraction = DateTimeUtils.pad(9, ldt.getNano());
        while (fraction.length() > precision && fraction.endsWith("0")) {
            fraction = fraction.substring(0, fraction.length() - 1);
        }
        StringBuilder ymdhms = DateTimeUtils.ymdhms(new StringBuilder(), ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        if (fraction.length() > 0) {
            ymdhms.append(".").append(fraction);
        }
        return ymdhms.toString();
    }

    public static String formatTimestamp(Timestamp ts, TimeZone tz, int precision) {
        return DateTimeUtils.formatTimestamp(DateTimeUtils.timestampWithLocalZoneToTimestamp(ts, tz), precision);
    }

    public static String formatTimestampMillis(int time, int precision) {
        StringBuilder buf = new StringBuilder(8 + (precision > 0 ? precision + 1 : 0));
        DateTimeUtils.formatTimestampMillis(buf, time, precision);
        return buf.toString();
    }

    private static void formatTimestampMillis(StringBuilder buf, int time, int precision) {
        while (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        int h = time / 3600000;
        int time2 = time % 3600000;
        int m = time2 / 60000;
        int time3 = time2 % 60000;
        int s = time3 / 1000;
        int ms = time3 % 1000;
        DateTimeUtils.int2(buf, h);
        buf.append(':');
        DateTimeUtils.int2(buf, m);
        buf.append(':');
        DateTimeUtils.int2(buf, s);
        if (precision > 0) {
            buf.append('.');
            while (precision > 0) {
                buf.append((char)(48 + ms / 100));
                ms %= 100;
                if ((ms *= 10) == 0) break;
                --precision;
            }
        }
    }

    public static String formatDate(int date) {
        StringBuilder buf = new StringBuilder(10);
        DateTimeUtils.formatDate(buf, date);
        return buf.toString();
    }

    private static void formatDate(StringBuilder buf, int date) {
        DateTimeUtils.julianToString(buf, date + 2440588);
    }

    private static void julianToString(StringBuilder buf, int julian) {
        int j = julian + 32044;
        int g = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g * 400 + c * 100 + b * 4 + a;
        int m = (da * 5 + 308) / 153 - 2;
        int d = da - (m + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m + 2) / 12;
        int month = (m + 2) % 12 + 1;
        int day = d + 1;
        DateTimeUtils.int4(buf, year);
        buf.append('-');
        DateTimeUtils.int2(buf, month);
        buf.append('-');
        DateTimeUtils.int2(buf, day);
    }

    private static boolean isLeapYear(int s) {
        return s % 400 == 0 || s % 4 == 0 && s % 100 != 0;
    }

    private static int ymdToUnixDate(int year, int month, int day) {
        int julian = DateTimeUtils.ymdToJulian(year, month, day);
        return julian - 2440588;
    }

    private static int ymdToJulian(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }

    public static Timestamp parseTimestampData(String dateStr, int precision) throws DateTimeException {
        return Timestamp.fromLocalDateTime(DateTimeUtils.fromTemporalAccessor(DEFAULT_TIMESTAMP_FORMATTER.parse(dateStr), precision));
    }

    public static Timestamp parseTimestampData(String dateStr, int precision, TimeZone timeZone) throws DateTimeException {
        return Timestamp.fromInstant(DateTimeUtils.fromTemporalAccessor(DEFAULT_TIMESTAMP_FORMATTER.parse(dateStr), precision).atZone(timeZone.toZoneId()).toInstant());
    }

    public static LocalDateTime toLocalDateTime(long timeMills) {
        return DateTimeUtils.toLocalDateTime(timeMills, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long timeMills, ZoneId zoneId) {
        return Instant.ofEpochMilli(timeMills).atZone(zoneId).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(String dateStr, int precision) {
        return DateTimeUtils.fromTemporalAccessor(DEFAULT_TIMESTAMP_FORMATTER.parse(dateStr), precision);
    }

    private static LocalDateTime fromTemporalAccessor(TemporalAccessor accessor, int precision) {
        int nanoOfSecond;
        int year = accessor.isSupported(ChronoField.YEAR) ? accessor.get(ChronoField.YEAR) : 1970;
        int month = accessor.isSupported(ChronoField.MONTH_OF_YEAR) ? accessor.get(ChronoField.MONTH_OF_YEAR) : 1;
        int day = accessor.isSupported(ChronoField.DAY_OF_MONTH) ? accessor.get(ChronoField.DAY_OF_MONTH) : 1;
        int hour = accessor.isSupported(ChronoField.HOUR_OF_DAY) ? accessor.get(ChronoField.HOUR_OF_DAY) : 0;
        int minute = accessor.isSupported(ChronoField.MINUTE_OF_HOUR) ? accessor.get(ChronoField.MINUTE_OF_HOUR) : 0;
        int second = accessor.isSupported(ChronoField.SECOND_OF_MINUTE) ? accessor.get(ChronoField.SECOND_OF_MINUTE) : 0;
        int n = nanoOfSecond = accessor.isSupported(ChronoField.NANO_OF_SECOND) ? accessor.get(ChronoField.NANO_OF_SECOND) : 0;
        if (precision == 0) {
            nanoOfSecond = 0;
        } else if (precision != 9) {
            nanoOfSecond = (int)DateTimeUtils.floor(nanoOfSecond, DateTimeUtils.powerX(10L, 9 - precision));
        }
        return LocalDateTime.of(year, month, day, hour, minute, second, nanoOfSecond);
    }

    private static long floor(long a, long b) {
        long r = a % b;
        if (r < 0L) {
            return a - r - b;
        }
        return a - r;
    }

    private static long powerX(long a, long b) {
        long x = 1L;
        while (b > 0L) {
            x *= a;
            --b;
        }
        return x;
    }

    public static long unixTimestamp(long ts) {
        return ts / 1000L;
    }

    public static Timestamp timestampToTimestampWithLocalZone(Timestamp ts, TimeZone tz) {
        return Timestamp.fromInstant(ts.toLocalDateTime().atZone(tz.toZoneId()).toInstant());
    }

    public static Timestamp timestampWithLocalZoneToTimestamp(Timestamp ts, TimeZone tz) {
        return Timestamp.fromLocalDateTime(LocalDateTime.ofInstant(ts.toInstant(), tz.toZoneId()));
    }

    public static int timestampWithLocalZoneToDate(Timestamp ts, TimeZone tz) {
        return DateTimeUtils.toInternal(LocalDateTime.ofInstant(Instant.ofEpochMilli(ts.getMillisecond()), tz.toZoneId()).toLocalDate());
    }

    public static int timestampWithLocalZoneToTime(Timestamp ts, TimeZone tz) {
        return DateTimeUtils.toInternal(LocalDateTime.ofInstant(Instant.ofEpochMilli(ts.getMillisecond()), tz.toZoneId()).toLocalTime());
    }

    public static Timestamp dateToTimestampWithLocalZone(int date, TimeZone tz) {
        return Timestamp.fromInstant(LocalDateTime.of(DateTimeUtils.toLocalDate(date), LocalTime.MIDNIGHT).atZone(tz.toZoneId()).toInstant());
    }

    public static Timestamp timeToTimestampWithLocalZone(int time, TimeZone tz) {
        return Timestamp.fromInstant(DateTimeUtils.toLocalDateTime(time).atZone(tz.toZoneId()).toInstant());
    }

    public static Timestamp truncate(Timestamp ts, int precision) {
        String fraction = Integer.toString(ts.toLocalDateTime().getNano());
        if (fraction.length() <= precision) {
            return ts;
        }
        if (precision <= 3) {
            return Timestamp.fromEpochMillis(DateTimeUtils.zeroLastDigits(ts.getMillisecond(), 3 - precision));
        }
        return Timestamp.fromEpochMillis(ts.getMillisecond(), (int)DateTimeUtils.zeroLastDigits(ts.getNanoOfMillisecond(), 9 - precision));
    }

    private static long zeroLastDigits(long l, int n) {
        long tenToTheN = (long)Math.pow(10.0, n);
        return l / tenToTheN * tenToTheN;
    }

    private static String pad(int length, long v) {
        StringBuilder s = new StringBuilder(Long.toString(v));
        while (s.length() < length) {
            s.insert(0, "0");
        }
        return s.toString();
    }

    private static StringBuilder ymdhms(StringBuilder b, int year, int month, int day, int h, int m, int s) {
        DateTimeUtils.ymd(b, year, month, day);
        b.append(' ');
        return DateTimeUtils.hms(b, h, m, s);
    }

    private static StringBuilder ymd(StringBuilder b, int year, int month, int day) {
        DateTimeUtils.int4(b, year);
        b.append('-');
        DateTimeUtils.int2(b, month);
        b.append('-');
        return DateTimeUtils.int2(b, day);
    }

    private static StringBuilder hms(StringBuilder b, int h, int m, int s) {
        DateTimeUtils.int2(b, h);
        b.append(':');
        DateTimeUtils.int2(b, m);
        b.append(':');
        return DateTimeUtils.int2(b, s);
    }

    private static StringBuilder int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        return buf.append((char)(48 + i % 10));
    }

    private static StringBuilder int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        return buf.append((char)(48 + i % 10));
    }
}

