/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.append.AppendCompactTask;
import org.apache.paimon.data.serializer.VersionedSerializer;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.utils.SerializationUtils;

public class AppendCompactTaskSerializer
implements VersionedSerializer<AppendCompactTask> {
    private static final int CURRENT_VERSION = 2;
    private final DataFileMetaSerializer dataFileSerializer = new DataFileMetaSerializer();

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public byte[] serialize(AppendCompactTask obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        this.serialize(obj, view);
        return out.toByteArray();
    }

    public void serializeList(List<AppendCompactTask> list, DataOutputView view) throws IOException {
        view.writeInt(list.size());
        for (AppendCompactTask commitMessage : list) {
            this.serialize(commitMessage, view);
        }
    }

    private void serialize(AppendCompactTask task, DataOutputView view) throws IOException {
        SerializationUtils.serializeBinaryRow(task.partition(), view);
        this.dataFileSerializer.serializeList(task.compactBefore(), view);
    }

    @Override
    public AppendCompactTask deserialize(int version, byte[] serialized) throws IOException {
        this.checkVersion(version);
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return this.deserialize(view);
    }

    public List<AppendCompactTask> deserializeList(int version, DataInputView view) throws IOException {
        this.checkVersion(version);
        int length = view.readInt();
        ArrayList<AppendCompactTask> list = new ArrayList<AppendCompactTask>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.deserialize(view));
        }
        return list;
    }

    private void checkVersion(int version) {
        if (version != 2) {
            throw new UnsupportedOperationException("Expecting CompactionTask version to be 2, but found " + version + ".\nCompactionTask is not a compatible data structure. Please restart the job afresh (do not recover from savepoint).");
        }
    }

    private AppendCompactTask deserialize(DataInputView view) throws IOException {
        return new AppendCompactTask(SerializationUtils.deserializeBinaryRow(view), this.dataFileSerializer.deserializeList(view));
    }
}

