/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.NameValuePairListMatcher;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.PercentCodec;
import org.apache.hc.core5.net.WWWFormCodec;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

class TestWWWFormCodec {
    private static final String CH_HELLO = "Gr\u00fcezi_z\u00e4m\u00e4";
    private static final String RU_HELLO = "\u0412\u0441\u0435\u043c_\u043f\u0440\u0438\u0432\u0435\u0442";

    TestWWWFormCodec() {
    }

    private static List<NameValuePair> parse(String params) {
        return WWWFormCodec.parse((CharSequence)params, (Charset)StandardCharsets.UTF_8);
    }

    @Test
    void testParse() {
        MatcherAssert.assertThat(TestWWWFormCodec.parse(""), NameValuePairListMatcher.isEmpty());
        MatcherAssert.assertThat(TestWWWFormCodec.parse("Name0"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name0", null)}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("Name1=Value1"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name1", "Value1")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("Name2="), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name2", "")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse(" Name3  "), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name3", null)}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("Name4=Value%204%21"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name4", "Value 4!")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("Name4=Value%2B4%21"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name4", "Value+4!")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("Name4=Value%204%21%20%214"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name4", "Value 4! !4")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("Name5=aaa&Name6=bbb"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name5", "aaa"), new BasicNameValuePair("Name6", "bbb")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("Name7=aaa&Name7=b%2Cb&Name7=ccc"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name7", "aaa"), new BasicNameValuePair("Name7", "b,b"), new BasicNameValuePair("Name7", "ccc")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("Name8=xx%2C%20%20yy%20%20%2Czz"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("Name8", "xx,  yy  ,zz")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("price=10%20%E2%82%AC"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("price", "10 \u20ac")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("a=b\"c&d=e"), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("a", "b\"c"), new BasicNameValuePair("d", "e")}));
        MatcherAssert.assertThat(TestWWWFormCodec.parse("russian=" + PercentCodec.encode((CharSequence)RU_HELLO, (Charset)StandardCharsets.UTF_8) + "&swiss=" + PercentCodec.encode((CharSequence)CH_HELLO, (Charset)StandardCharsets.UTF_8)), NameValuePairListMatcher.equalsTo(new NameValuePair[]{new BasicNameValuePair("russian", RU_HELLO), new BasicNameValuePair("swiss", CH_HELLO)}));
    }

    private static String format(NameValuePair ... nvps) {
        return WWWFormCodec.format(Arrays.asList(nvps), (Charset)StandardCharsets.UTF_8);
    }

    @Test
    void testFormat() {
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("Name0", null)}), (Matcher)CoreMatchers.equalTo((Object)"Name0"));
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("Name1", "Value1")}), (Matcher)CoreMatchers.equalTo((Object)"Name1=Value1"));
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("Name2", "")}), (Matcher)CoreMatchers.equalTo((Object)"Name2="));
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("Name4", "Value 4&")}), (Matcher)CoreMatchers.equalTo((Object)"Name4=Value+4%26"));
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("Name4", "Value+4&")}), (Matcher)CoreMatchers.equalTo((Object)"Name4=Value%2B4%26"));
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("Name4", "Value 4& =4")}), (Matcher)CoreMatchers.equalTo((Object)"Name4=Value+4%26+%3D4"));
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("Name5", "aaa"), new BasicNameValuePair("Name6", "bbb")}), (Matcher)CoreMatchers.equalTo((Object)"Name5=aaa&Name6=bbb"));
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("Name7", "aaa"), new BasicNameValuePair("Name7", "b,b"), new BasicNameValuePair("Name7", "ccc")}), (Matcher)CoreMatchers.equalTo((Object)"Name7=aaa&Name7=b%2Cb&Name7=ccc"));
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("Name8", "xx,  yy  ,zz")}), (Matcher)CoreMatchers.equalTo((Object)"Name8=xx%2C++yy++%2Czz"));
        MatcherAssert.assertThat((Object)TestWWWFormCodec.format(new NameValuePair[]{new BasicNameValuePair("russian", RU_HELLO), new BasicNameValuePair("swiss", CH_HELLO)}), (Matcher)CoreMatchers.equalTo((Object)("russian=" + PercentCodec.encode((CharSequence)RU_HELLO, (Charset)StandardCharsets.UTF_8) + "&swiss=" + PercentCodec.encode((CharSequence)CH_HELLO, (Charset)StandardCharsets.UTF_8))));
    }
}

