/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.DoubleClickList;
import com.ibm.as400.vaccess.LabelledComponent;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SQLQueryBuilderPane;
import com.ibm.as400.vaccess.SQLQueryClause;
import com.ibm.as400.vaccess.SQLQueryFieldsPane;
import com.ibm.as400.vaccess.ScrollingTextPane;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

class SQLQueryJoinPane
extends SQLQueryFieldsPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int INNER_JOIN = 1;
    public static final int OUTER_JOIN = 2;
    private ButtonGroup joinButtonGroup_;
    private JPanel joinButtonPanel_;
    private DefaultListModel tableListModel_;
    DoubleClickList tableList_;
    DoubleClickList testList_;
    DoubleClickList otherList_;
    JRadioButton innerJoinButton_;
    private JRadioButton outerJoinButton_;
    private SQLQueryClause clause_;
    private boolean secondField_ = false;
    private Vector clauses_ = new Vector();
    int current_ = 0;
    int currentTable_ = 0;
    private Vector locationInClause_ = new Vector();
    static final String[] testChoices = new String[]{"=", "<>", "<", ">", "<=", ">="};
    static final String[] otherChoices = new String[]{"AND"};

    public SQLQueryJoinPane(SQLQueryBuilderPane parent) {
        super(parent);
    }

    private void buildTableList() {
        String[] tables = this.parent_.getTables();
        int numTables = tables.length - 1;
        this.tableListModel_.removeAllElements();
        if (numTables > 0) {
            this.tableListModel_.addElement(tables[0] + " + " + tables[1]);
        }
        for (int i = 1; i < numTables; ++i) {
            this.tableListModel_.addElement("+ " + tables[i + 1]);
        }
        while (this.clauses_.size() < numTables) {
            this.clauses_.addElement("");
            this.locationInClause_.addElement(1);
        }
    }

    public void complete() {
        if (this.clauses_.size() > 0) {
            this.clauses_.setElementAt(this.clause_.getText(), this.current_);
        }
    }

    public String getClause(int index) {
        if (this.clause_ == null || this.clauses_.size() == 0) {
            return null;
        }
        return (String)this.clauses_.elementAt(index);
    }

    public int getJoinType() {
        if (this.joinButtonGroup_ == null) {
            return 1;
        }
        ButtonModel selection = this.joinButtonGroup_.getSelection();
        if (selection == this.innerJoinButton_.getModel()) {
            return 1;
        }
        return 2;
    }

    void otherPicked(String item) {
        this.clause_.appendText(item);
        this.otherList_.setEnabled(false);
        this.fields_.setEnabled(true);
        this.locationInClause_.setElementAt(1, this.current_);
    }

    @Override
    protected void rowPicked(int index) {
        if ((Integer)this.locationInClause_.elementAt(this.current_) == 1) {
            this.clause_.appendText("(" + this.fieldName(index));
            this.testList_.setEnabled(true);
            this.locationInClause_.setElementAt(2, this.current_);
        } else {
            this.clause_.appendText(this.fieldName(index) + ")");
            this.otherList_.setEnabled(true);
            this.locationInClause_.setElementAt(4, this.current_);
        }
        this.fields_.setEnabled(false);
    }

    @Override
    protected void setupPane() {
        super.setupPane();
        JoinListener_ l = new JoinListener_();
        this.outerJoinButton_ = new JRadioButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_OUTER_JOIN"), false);
        this.outerJoinButton_.setName("joinOuterButton");
        this.outerJoinButton_.addActionListener(l);
        this.innerJoinButton_ = new JRadioButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_INNER_JOIN"), true);
        this.innerJoinButton_.setName("joinInnerButton");
        this.innerJoinButton_.addActionListener(l);
        this.joinButtonGroup_ = new ButtonGroup();
        this.joinButtonGroup_.add(this.innerJoinButton_);
        this.joinButtonGroup_.add(this.outerJoinButton_);
        Box buttonBox = Box.createVerticalBox();
        buttonBox.add(this.innerJoinButton_);
        buttonBox.add(this.outerJoinButton_);
        this.joinButtonPanel_ = new JPanel();
        this.joinButtonPanel_.setLayout(new BorderLayout());
        this.joinButtonPanel_.setBorder(new TitledBorder(ResourceLoader.getQueryText("DBQUERY_LABEL_JOIN_TYPE")));
        this.joinButtonPanel_.add("Center", buttonBox);
        this.tableListModel_ = new DefaultListModel();
        this.buildTableList();
        this.tableList_ = new DoubleClickList(this.tableListModel_);
        this.tableList_.setVisibleRowCount(3);
        this.tableList_.setSelectedIndex(this.current_);
        this.tableList_.setEnabled(false);
        this.tableList_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SQLQueryJoinPane.this.tablePicked(SQLQueryJoinPane.this.tableList_.getSelectedIndex());
            }
        });
        Box topRow = Box.createHorizontalBox();
        topRow.add(this.joinButtonPanel_);
        topRow.add(new LabelledComponent("DBQUERY_LABEL_TABLES", this.tableList_));
        this.testList_ = new DoubleClickList(testChoices);
        this.testList_.setEnabled(false);
        this.testList_.setVisibleRowCount(6);
        this.testList_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SQLQueryJoinPane.this.testPicked((String)event.getItem());
            }
        });
        this.otherList_ = new DoubleClickList(otherChoices);
        this.otherList_.setEnabled(false);
        this.otherList_.setVisibleRowCount(6);
        this.otherList_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SQLQueryJoinPane.this.otherPicked((String)event.getItem());
            }
        });
        Box middleRow = Box.createHorizontalBox();
        middleRow.add(new LabelledComponent("DBQUERY_LABEL_TEST", this.testList_));
        middleRow.add(new LabelledComponent("DBQUERY_LABEL_OTHER", this.otherList_));
        this.clause_ = new SQLQueryClause(5);
        Box overallBox = Box.createVerticalBox();
        overallBox.add(topRow);
        overallBox.add(this.fields_);
        overallBox.add(middleRow);
        overallBox.add(new LabelledComponent("DBQUERY_LABEL_CLAUSE_JOIN", new ScrollingTextPane(this.clause_)));
        this.setLayout(new BorderLayout());
        this.add("Center", overallBox);
    }

    void tablePicked(int item) {
        this.complete();
        this.clause_.setText((String)this.clauses_.elementAt(item));
        this.current_ = item;
        switch ((Integer)this.locationInClause_.elementAt(item)) {
            case 1: 
            case 3: {
                this.fields_.setEnabled(true);
                this.testList_.setEnabled(false);
                this.otherList_.setEnabled(false);
                break;
            }
            case 2: {
                this.fields_.setEnabled(false);
                this.testList_.setEnabled(true);
                this.otherList_.setEnabled(false);
                break;
            }
            case 4: {
                this.fields_.setEnabled(false);
                this.testList_.setEnabled(false);
                this.otherList_.setEnabled(true);
            }
        }
    }

    void testPicked(String item) {
        this.clause_.appendText(item);
        this.testList_.setEnabled(false);
        this.fields_.setEnabled(true);
        this.locationInClause_.setElementAt(3, this.current_);
    }

    @Override
    public void update() {
        boolean update = this.fieldsChanged_;
        super.update();
        if (update) {
            this.buildTableList();
            if (this.currentTable_ > this.parent_.getTables().length - 1) {
                this.currentTable_ = 0;
                if (this.getJoinType() == 2) {
                    this.current_ = this.currentTable_;
                }
            }
            this.tableList_.setSelectedIndex(this.current_);
        }
    }

    private class JoinListener_
    implements ActionListener {
        private JoinListener_() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == SQLQueryJoinPane.this.innerJoinButton_) {
                if (SQLQueryJoinPane.this.tableList_.isEnabled()) {
                    SQLQueryJoinPane.this.tableList_.setEnabled(false);
                    SQLQueryJoinPane.this.tablePicked(0);
                }
            } else {
                SQLQueryJoinPane.this.tableList_.setEnabled(true);
                SQLQueryJoinPane.this.tablePicked(SQLQueryJoinPane.this.currentTable_);
            }
        }
    }
}

