/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlobOutputStream;
import com.ibm.as400.access.JDError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;

public class AS400JDBCBlob
implements Blob,
Serializable {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private byte[] data_;
    private int maxLength_;
    static final int MAX_LOB_SIZE = Integer.MAX_VALUE;

    AS400JDBCBlob(byte[] data, int maxLength) {
        this.data_ = data;
        this.maxLength_ = maxLength;
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        return new ByteArrayInputStream(this.data_);
    }

    @Override
    public synchronized byte[] getBytes(long position, int length) throws SQLException {
        int lengthToUse;
        int offset;
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if ((offset = (int)position - 1) < 0 || length < 0 || offset + length > this.data_.length) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        if ((lengthToUse = this.data_.length - offset) < 0) {
            return new byte[0];
        }
        if (lengthToUse > length) {
            lengthToUse = length;
        }
        byte[] result = new byte[lengthToUse];
        System.arraycopy(this.data_, offset, result, 0, lengthToUse);
        return result;
    }

    @Override
    public synchronized long length() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        return this.data_.length;
    }

    @Override
    public synchronized long position(byte[] pattern, long position) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        int offset = (int)position - 1;
        if (pattern == null || offset < 0 || offset >= this.data_.length) {
            JDError.throwSQLException((Object)this, "HY024");
        } else {
            int end = this.data_.length - pattern.length;
            for (int i = offset; i <= end; ++i) {
                int j;
                for (j = 0; j < pattern.length && this.data_[i + j] == pattern[j]; ++j) {
                }
                if (j != pattern.length) continue;
                return i + 1;
            }
        }
        return -1L;
    }

    @Override
    public synchronized long position(Blob pattern, long position) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        int offset = (int)position - 1;
        if (pattern == null || offset < 0 || offset >= this.data_.length) {
            JDError.throwSQLException((Object)this, "HY024");
        } else {
            int patternLength = (int)pattern.length();
            if (patternLength > this.data_.length || patternLength < 0) {
                return -1L;
            }
            int end = this.data_.length - patternLength;
            byte[] bytePattern = pattern.getBytes(1L, patternLength);
            for (int i = offset; i <= end; ++i) {
                int j;
                for (j = 0; j < patternLength && this.data_[i + j] == bytePattern[j]; ++j) {
                }
                if (j != patternLength) continue;
                return i + 1;
            }
        }
        return -1L;
    }

    @Override
    public synchronized OutputStream setBinaryStream(long position) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (position <= 0L || position > (long)this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        return new AS400JDBCBlobOutputStream(this, position);
    }

    synchronized int setByte(long position, byte data) throws SQLException {
        int numBytes;
        int newSize;
        int offset;
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if ((offset = (int)position - 1) < 0 || offset >= this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        if ((newSize = offset + 1) < 0) {
            newSize = Integer.MAX_VALUE;
        }
        if (newSize > this.data_.length) {
            byte[] temp = this.data_;
            this.data_ = new byte[newSize];
            System.arraycopy(temp, 0, this.data_, 0, temp.length);
        }
        if ((numBytes = newSize - offset) > 0) {
            this.data_[offset] = data;
            return 1;
        }
        return 0;
    }

    @Override
    public synchronized int setBytes(long position, byte[] bytesToWrite) throws SQLException {
        if (this.data_ == null) {
            throw JDError.throwSQLException((Object)this, "HY010");
        }
        int offset = (int)position - 1;
        if (offset < 0 || offset >= this.maxLength_ || bytesToWrite == null) {
            throw JDError.throwSQLException((Object)this, "HY024");
        }
        int newSize = offset + bytesToWrite.length;
        if (newSize < 0) {
            newSize = Integer.MAX_VALUE;
        }
        if (newSize > this.data_.length) {
            byte[] temp = this.data_;
            this.data_ = new byte[newSize];
            System.arraycopy(temp, 0, this.data_, 0, temp.length);
        }
        int numBytes = newSize - offset;
        System.arraycopy(bytesToWrite, 0, this.data_, offset, numBytes);
        return numBytes;
    }

    @Override
    public synchronized int setBytes(long position, byte[] bytesToWrite, int offset, int lengthOfWrite) throws SQLException {
        int newSize;
        int blobOffset;
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if ((blobOffset = (int)position - 1) < 0 || blobOffset >= this.maxLength_ || bytesToWrite == null || offset < 0 || lengthOfWrite < 0 || offset + lengthOfWrite > bytesToWrite.length || blobOffset + lengthOfWrite > this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        if ((newSize = blobOffset + lengthOfWrite) < 0) {
            newSize = Integer.MAX_VALUE;
        }
        if (newSize > this.data_.length) {
            byte[] temp = this.data_;
            this.data_ = new byte[newSize];
            System.arraycopy(temp, 0, this.data_, 0, temp.length);
        }
        int numBytes = newSize - blobOffset;
        System.arraycopy(bytesToWrite, offset, this.data_, blobOffset, numBytes);
        return numBytes;
    }

    @Override
    public synchronized void truncate(long lengthOfBLOB) throws SQLException {
        int length;
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if ((length = (int)lengthOfBLOB) < 0 || length > this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        byte[] temp = this.data_;
        this.data_ = new byte[length];
        int numToCopy = length < temp.length ? length : temp.length;
        System.arraycopy(temp, 0, this.data_, 0, numToCopy);
    }

    @Override
    public synchronized void free() throws SQLException {
        this.data_ = null;
    }

    @Override
    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        return new ByteArrayInputStream(this.data_, (int)pos, (int)length);
    }
}

