/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public class DefaultRows
extends Rows {
    private final RowsMetadata metadata;
    private final Queue<List<ByteBuffer>> data;

    public DefaultRows(RowsMetadata metadata, Queue<List<ByteBuffer>> data) {
        this.metadata = metadata;
        this.data = data;
    }

    @Override
    public RowsMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Queue<List<ByteBuffer>> getData() {
        return this.data;
    }

    public String toString() {
        return "ROWS(" + this.data.size() + " x " + this.metadata.columnCount + " columns)";
    }

    public static class SubCodec
    extends Result.SubCodec {
        public SubCodec(int protocolVersion) {
            super(2, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            DefaultRows rows = (DefaultRows)message;
            rows.metadata.encode(dest, encoder, false, this.protocolVersion);
            encoder.writeInt(rows.data.size(), dest);
            for (List row : rows.data) {
                for (ByteBuffer column : row) {
                    encoder.writeBytes(column, dest);
                }
            }
        }

        @Override
        public int encodedSize(Message message) {
            DefaultRows rows = (DefaultRows)message;
            int size = rows.metadata.encodedSize(false, this.protocolVersion) + 4;
            for (List row : rows.data) {
                for (ByteBuffer column : row) {
                    size += PrimitiveSizes.sizeOfBytes(column);
                }
            }
            return size;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            RowsMetadata metadata = RowsMetadata.decode(source, decoder, false, this.protocolVersion);
            int rowCount = decoder.readInt(source);
            ArrayDeque<List<ByteBuffer>> data = new ArrayDeque<List<ByteBuffer>>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                NullAllowingImmutableList.Builder<ByteBuffer> row = NullAllowingImmutableList.builder(metadata.columnCount);
                for (int j = 0; j < metadata.columnCount; ++j) {
                    row.add(decoder.readBytes(source));
                }
                data.add(row.build());
            }
            return new DefaultRows(metadata, data);
        }
    }
}

