/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.Collections;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordAttributesCombiner {
    private static final Logger LOG = LoggerFactory.getLogger(RecordAttributesCombiner.class);
    private final RecordAttributes[] allChannelRecordAttributes;
    private int backlogChannelCnt = 0;
    private int backlogUndefinedChannelCnt;
    private RecordAttributes lastOutputAttributes = null;

    public RecordAttributesCombiner(int numInputChannels) {
        this.backlogUndefinedChannelCnt = numInputChannels;
        this.allChannelRecordAttributes = new RecordAttributes[numInputChannels];
    }

    public void inputRecordAttributes(RecordAttributes recordAttributes, int channelIdx, PushingAsyncDataInput.DataOutput<?> output) throws Exception {
        LOG.debug("RecordAttributes: {} from channel idx: {}", (Object)recordAttributes, (Object)channelIdx);
        RecordAttributes lastChannelRecordAttributes = this.allChannelRecordAttributes[channelIdx];
        this.allChannelRecordAttributes[channelIdx] = recordAttributes;
        if (recordAttributes.equals(lastChannelRecordAttributes)) {
            return;
        }
        RecordAttributesBuilder builder = new RecordAttributesBuilder(Collections.emptyList());
        Boolean isBacklog = this.combineIsBacklog(lastChannelRecordAttributes, recordAttributes);
        if (isBacklog == null) {
            if (this.lastOutputAttributes == null) {
                return;
            }
            isBacklog = this.lastOutputAttributes.isBacklog();
        }
        builder.setBacklog(isBacklog);
        RecordAttributes outputAttribute = builder.build();
        if (!outputAttribute.equals(this.lastOutputAttributes)) {
            output.emitRecordAttributes(outputAttribute);
            this.lastOutputAttributes = outputAttribute;
        }
    }

    private Boolean combineIsBacklog(RecordAttributes lastRecordAttributes, RecordAttributes recordAttributes) {
        if (lastRecordAttributes == null) {
            --this.backlogUndefinedChannelCnt;
            if (recordAttributes.isBacklog()) {
                ++this.backlogChannelCnt;
            }
        } else if (lastRecordAttributes.isBacklog() != recordAttributes.isBacklog()) {
            this.backlogChannelCnt = recordAttributes.isBacklog() ? ++this.backlogChannelCnt : --this.backlogChannelCnt;
        }
        if (this.backlogChannelCnt > 0) {
            return true;
        }
        if (this.backlogUndefinedChannelCnt > 0) {
            return null;
        }
        return false;
    }
}

